@if(userCan('setting-create')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'New Competencies '; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
               @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings/competency"> Competencies List </a></li>
              @endif
              @if(userCan('setting-create')>0)
              <li class="breadcrumb-item active"><a href="/settings/competency/create"> Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
@stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <div class="card-body">
                <form method="POST" action="/settings/competency/store" role="form" id="">
                 {{ csrf_field() }}
                  <div class="row">
                    <div class="col-sm-6">
                      <div class="form-group">
                        <label>Competencies Name *</label>
                        <input type="text" class="form-control" name="competencies" value="{{old('competencies')}}" placeholder="Enter ..." required >
                      </div>
                    </div>




                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Category *</label>
                        <br>
                        <label>  <input type="radio" class="form-contro" name="category" value="1" required > Core</label>
                        <label>  <input type="radio" class="form-contro" name="category" value="2" > Job Specific </label>
                      </div>
                    </div>

                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Type *</label>
                        <select class="form-control" name="type_id" required>
                          <option value="">-</option>
                          {!!CompetencyType()!!}
                        </select>
                      </div>
                    </div>                     

                    <div class="col-sm-12">
                      <div class="form-group">
                        <label>Descriptions </label>
                        <textarea class="form-control" name="description" rows="5">{{old('description')}}</textarea>
                      </div>
                    </div>                   


                  </div>
                  <!-- /end row -->


                  <!-- /end row -->

                <div class="row">


                <div class="col-md-12">
                  <br>
                  <br>
                  <div class="" align="right">
                    <button type="submit" class="btn btn-primary"> Save </button>
                  </div>
                </div>

               </div>
               <!-- /end row -->


                </form>
              </div>
              <!-- /.card-body -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->




@stop