@if(userCan('SetProviderName-list')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif

@extends('layouts.default')
@php $pageTitle = 'Provider Name List'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif

@php
 $BankName= app('request')->input('bankName');
 $appPerPage= app('request')->input('perPage');
@endphp

<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
               @if(userCan('SetProviderName-list')>0)
              <li class="breadcrumb-item "><a href="?"> {{$pageTitle}} </a></li>
              @endif
              @if(userCan('SetProviderName-create')>0)
              <li class="breadcrumb-item active"><a href="/settings/SetProviderName/create/"> Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

 @stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <!-- /.card -->

            <div class="card">
              <!-- <div class="card-header">
                <h3 class="card-title">Employee List</h3>
              </div> -->
              <!-- /.card-header -->
              <form method="get" action="" role="form" >
                
                <div class="card-header">

                Per Page
                  @php  $curentperPagesnum = isset($_GET['perPage'])?$_GET['perPage']:10; @endphp
                  @php  $perPages = array(10,15,20,50,100,500,1000);@endphp
                  <select name="perPage" id="perPage" onchange="this.form.submit()">
                    <option value="{{@$appPerPage}}">Select All</option>
                    @foreach( $perPages as $key =>$perPagesnum )
                    <option @if($curentperPagesnum == $perPagesnum) selected="selected" @endif value="{{$perPagesnum}}">{{$perPagesnum}}</option>
                    @endforeach
                  </select>
     

                <div class="card-tools">
                  <div class="input-group" style="width: auto">

                        <input type="text" class="form-control" name="bankName" placeholder="Provider Name" value="{{@$BankName}}">&emsp;

                    <div class="input-group-append">
                      <button type="submit" class="btn btn-default btn-sm" onchange="this.form.submit()">
                        <i class="fas fa-search"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
              </form>

              <div class="col-md-12" >
                {{paginationHeaderInfo($datas)}}
                  <div class="col-md-12 pagination-area" >
                    {{$datas->appends([              
                        'bankName' => $BankName,
                        'perPage' => $appPerPage  
                    ])->links('pagination::bootstrap-4')}}
                  </div>
              </div>
              <hr>

              <div class="card-body table-responsive p-0 textCapital">
                <table class="table table-hover  table-striped">
                  <thead>
                    <tr>
                      <th>Provider Name</th>
                      <th>Type</th>
                      <th>Status</th>
                      <th>Action</th>
                    </tr>   
 
                  </thead>
                  <tbody>
                    @foreach($datas as $key=>$data)

                    <tr>
                      <td>
                        {{@$data->bankName}}
                      </td>

                      <td>
                        @if((@$data->type)==1) Bank
                        @elseif((@$data->type)==2) Mobile(MFS)
                        @elseif((@$data->type)==3) Online
                        @else Others 
                        @endif
                      </td>

                      <td>
                        @if((@$data->status)==1) Active @else Deactive @endif
                      </td>
  
                      <td>
                        @if(userCan('SetProviderName-edit')>0)
                        <a href="/settings/SetProviderName/{{@$data->id}}/edit"> <i class="fa fa-edit"></i></a>
                        @endif
                      </td>
                    </tr>
                  @endforeach
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
          
          <div class="col-md-12" >
            {{paginationHeaderInfo($datas)}}
              <div class="col-md-12 pagination-area" >
                {{$datas->appends([              
                    'bankName' => $BankName,
                    'perPage' => $appPerPage  
                ])->links('pagination::bootstrap-4')}}
              </div>
          </div>

      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->

@stop