@if(userCan('branch-create')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'Update Branch '; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
              @if(userCan('branch-list')>0)
              <li class="breadcrumb-item "><a href="/settings/branch"> Branch List </a></li>
              @endif
              @if(userCan('branch-create')>0)
              <li class="breadcrumb-item active"><a href="/settings/branch/create"> Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
@stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <div class="card-body">
                <form method="POST" action="/settings/branch/update" role="form" id="">
                 {{ csrf_field() }}
                 @method('PUT')

                 <input type="hidden" name="id" value="{{$data->id}}">
                 <input type="hidden" name="url" value="{{url()->previous()}}">
                  <div class="row">

                    

                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Branch Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="branch_name" value="{{$data->branch_name}}" placeholder="Enter ..." required >
                      </div>
                    </div>

                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Company Name</label>
                        <select class="form-control" name="company_id" >
                          <option value="">Select one</option>
                          {!!company_list($data->company_id)!!}
                        </select>
                      </div>
                    </div>

                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Phone</label>
                        <input type="text" class="form-control" name="branch_contact" value="{{$data->branch_contact}}" placeholder="Branch Phone / Mobile" >
                      </div>
                    </div>

                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Email</label>
                        <input type="text" class="form-control" name="branch_email" value="{{$data->branch_email}}" placeholder="Branch Email .." >
                      </div>
                    </div>
                  


                  </div>

                  <div class="row">
                    <!-- left column -->
                    <div class="col-md-6">
                      <!-- jquery validation -->
                      <div class="card card-primary">
                        <div class="card-header">
                          <h3 class="card-title"> Branch Contact Details </h3>
                        </div>

                        <div class="card-body">
                          <div class="row">               
                            <!-- <div class="col-sm-6"> -->
                          <div class="col-sm-6">
                          <div class="form-group">
                            <input type="text" name="contact_name" value="{{$data->contact_name}}" class="form-control" autocomplete="off" placeholder="Contact Name">
                          </div>
                        </div>

                         <div class="col-sm-6">
                          <div class="form-group">
                            <input type="text" name="contact_designation" value="{{$data->contact_designation}}" class="form-control" autocomplete="off" placeholder="designation" >
                          </div>
                          </div>

                          <div class="col-sm-6">
                          <div class="form-group">
                            <input type="text" name="contact_number" value="{{$data->contact_number}}" class="form-control" autocomplete="off" placeholder="contact person mobile ">
                          </div>
                        </div>

                        <div class="col-sm-6">
                          <div class="form-group">
                            <input type="text" name="contact_email" value="{{$data->contact_email}}" class="form-control" autocomplete="off" placeholder="contact person email" >
                          </div>
                        </div>



                            </div>


                          </div>
                        <!-- </div> -->
                        
                      
                        

                      </div>
                    </div>

                    <div class="col-md-6">
                  <!-- jquery validation -->
                  <div class="card card-warning">
                    <div class="card-header">
                      <h3 class="card-title"> Branch Address </h3>
                    </div>
                    <!-- /.card-header -->
                    <!-- form start -->
              
                      <div class="card-body">
                        <div class="row">
                        <div class="col-sm-12">
                        <div class="form-group">
                          <textarea class="form-control" name="branch_address" placeholder="Full Address">{{$data->branch_address}}</textarea>
                        </div> 
                       </div>

                       <div class="col-sm-6">
                      <div class="form-group">
                        <input type="text" name="branch_city" value="{{$data->branch_city}}" class="form-control" autocomplete="off" placeholder=" branch city ">
                      </div>
                    </div>

                    <div class="col-sm-6">
                      <div class="form-group">
                        <input type="text" name="branch_division" value="{{$data->branch_division}}" class="form-control" autocomplete="off" placeholder="branch division">
                      </div>
                    </div>

                    <div class="col-sm-6">
                      <div class="form-group">
                        <input type="text" name="post_code" value="{{$data->post_code}}" class="form-control" autocomplete="off" placeholder="branch post code ">
                      </div>
                    </div>

                    <div class="col-sm-6">
                      <div class="form-group">
                        <select class="form-control" name="country_id" >
                          <option value="">Select Country</option>
                          {!!countrie_list($data->country_id)!!}
                        </select>
                      </div>
                    </div>



                        </div>                         

                      </div>
                      <!-- /.card-body -->
                    </div>
                  <!-- /.card -->
                  </div>
                  </div>
                  <!-- /end row -->

                 
                     


                  <!-- /end row -->

                <div class="row">
                <!-- left column -->
                
                <!--/.col (left) -->
                </div>
               <!-- /end row -->


                <div class="col-md-12">
                  <br>
                  <div class="" align="right">
                    <button type="submit" class="btn btn-primary"> Save </button>
                  </div>
                </div>

                </form>
              </div>
              <!-- /.card-body -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->




@stop