@extends('layouts.default')
@php $pageTitle = 'Member List'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('Vendor-list')>0)
              <li class="breadcrumb-item "><a href="?"> {{$pageTitle}} </a></li>
              @endif
              @if(userCan('Vendor-create')>0)
              <li class="breadcrumb-item active"><a href="/member/new"> New Registration</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

 @stop


@php
 //$limit= app('request')->input('limit');
 $name= app('request')->input('name');
 $contact= app('request')->input('contact');
 $ssc= app('request')->input('ssc');
 $hsc= app('request')->input('hsc');
 $status= app('request')->input('status'); 
 $perpage = ((app('request')->input('limit'))>0) ? app('request')->input('limit') : 25;
@endphp

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <!-- /.card -->

            <div class="card">
              <!-- <div class="card-header">
                <h3 class="card-title">vendor List</h3>
              </div> -->
              <!-- /.card-header -->
              <form method="" action="" role="form" >
                <!--{{ csrf_field() }} -->
                <div class="card-header">
                Per Page
                  <select name="limit" class="">
                      <option value="10" @if($perpage==10) selected @endif > 10 </option>
                      <option value="25" @if($perpage==25) selected @endif >25</option>
                      <option value="50" @if($perpage==50) selected @endif >50</option>
                      <option value="100" @if($perpage==100) selected @endif >100</option>
                      <option value="500" @if($perpage==500) selected @endif >500</option>
                      <option value="1000" @if($perpage==1000) selected @endif >1000</option>
                  </select>
                <div class="card-tools">
                  <div class="input-group" style="width: auto">
                    <input type="text" name="name" value="{{$name}}"
                      class="form-control form-control-sm float-right"
                      placeholder="name">
                      
                      <input type="text" name="contact" value="{{$contact}}"
                      class="form-control form-control-sm float-right"
                      placeholder="contact">
                      
                      <input type="text" name="ssc" value="{{$ssc}}"
                      class="form-control form-control-sm float-right"
                      placeholder="SSC batch">
                      
                      <input type="text" name="hsc" value="{{$hsc}}"
                      class="form-control form-control-sm float-right"
                      placeholder="HSC batch">
                      
                    <div class="input-group-append ">
                      <!-- <label>Satus</label> -->
                      <select name="status"
                        class="custom-select custom-select-sm form-control form-control-sm">
                        <option value="">Search - All</option>
                        <option value="1" @if($status==1) selected @endif>Active</option>
                        <option value="2" @if($status==2) selected @endif>Pending</option>
                        <option value="0" @if(isset($status) && $status==0) selected @endif>In-Active</option>
                      </select>
                    </div>

                    <div class="input-group-append">
                      <button type="submit" class="btn btn-default btn-sm">
                        <i class="fas fa-search"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
              </form>


            <div class="col-md-12" >
              {{paginationHeaderInfo($datas)}}
                <div class="col-md-12 pagination-area" >
                  {{$datas->appends([              
                  ])->links('pagination::bootstrap-4')}}
                </div>
            </div>

              <div class="card-body table-responsive p-0">
                <table class="table table-hover  table-striped">
                  <thead>
                    <tr>
                      <th width="100">ID </th>
                      <th>Member Name </th>
                      <th>Contact</th>
                      <th>SSC Batch </th>
                      <th>HSC Batch </th>
                      <th>Status</th>
                       <th>Created & Updated</th>
                      <th>Acction </th>
                    </tr>   
 
                  </thead>
                  <tbody>
                  @foreach($datas as $key=>$data) 
                    <tr>
                        <td>{{$data->id}} <br> <span class="text-blue small">{{@$data->reg_date}}</span> </td>
                      <td>{{$data->name}} <br> <span class="text-blue small">{{@$data->name_bangla}}</span>
                       </td>
                      <td>{{$data->mobile}} <br> <span class="text-blue small">{{@$data->email}}</span></td>
                      <td>{{@$data->ssc_batch}} <br> <span class="text-blue small">{{@$data->ssc_dept}}</span></td>
                      <td>{{@$data->hsc_batch}} <br> <span class="text-blue small">{{@$data->hsc_dept}}</span></td>
                      
                      <td>@if($data->status==1) Active @elseif($data->status==2) Pending @else Deactive @endif </td>
                      <td> <span class=" small">{{@$data->created_at}}</span> <br> <span class="text-blue small">{{@$data->updated_at}}</span> </td>
                      <td style="width:100px">
                        <a href="/member/index/{{$data->id}}/edit"> <i class="fa fa-edit"></i></a>
                      </td>
                    </tr>
                  @endforeach
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        
        <div class="col-md-12" >
              {{paginationHeaderInfo($datas)}}
                <div class="col-md-12 pagination-area" >
                  {{$datas->appends([              
                  ])->links('pagination::bootstrap-4')}}
                </div>
            </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->

<style>
  .list-img{width: 20%; height: auto;  float: left;  }
  .list-img img { border-radius: 50%; border:1px solid #fff; padding: 2px; height: auto; max-width: 100%; }
  img { vertical-align: middle; border-style: none;}
  .list-name{width: 79%; float: left; background: transparent; padding-right: 15px;}
</style>    
@stop