@extends('layouts.default')
@php $pageTitle = 'Update Member Registration  '; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i> </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('Vendor-list')>0)
              <li class="breadcrumb-item "><a href="/member/index"> Member List </a></li>
              @endif
              @if(userCan('Vendor-create')>0)
              <li class="breadcrumb-item active"><a href="/member/new"> New Member</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
@stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <div class="card-body">
                <form method="POST" action="/member/update/{{$data->id}}" role="form" id="" enctype="multipart/form-data">
                    @csrf
                    {{ method_field('PUT') }}
                  <input type="hidden" name="url" value="{{URL::previous()}}">
                  <input type="hidden" name="id" value="{{$data->id}}">
                      
                      
                  <div class="row">
                    
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Name (English)</label>    
                        <input type="text" class="form-control" name="name" placeholder="English Name ..." value="{{$data->name}}" autofocus >
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Name (বাংলা )</label>    
                        <input type="text" class="form-control" name="name_bangla" placeholder="বাংলা নাম ..." value="{{$data->name_bangla}}" >
                      </div>
                    </div>
                    
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Father's Name</label>      
                        <input type="text" class="form-control" name="fathers_name" placeholder="Enter..." value="{{$data->fathers_name}}" >
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Mother's Name </label>   
                        <input type="text" class="form-control" name="mothers_name" placeholder="Enter..." value="{{$data->mothers_name}}" >
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Permanent Address</label> 
                        <input type="text" class="form-control" name="address_present" placeholder="Enter..." value="{{$data->address_present}}" >
                      </div>
                    </div>
    
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Present Address</label> 
                        <input type="text" class="form-control" name="address_permanent" placeholder="Enter..." value="{{$data->address_permanent}}" >
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>SSC Batch</label> 
                        <input type="number" min="1950" max="{{date('Y')}}" class="form-control" name="ssc_batch" placeholder="Enter..." value="{{$data->ssc_batch}}"  >
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>SSC Department</label> 
                      
                        <select class="form-control" name="ssc_dept" style="" >
                        <option value=""  @if(old('ssc_dept')=='') selected @endif > - </option>
                        <option value="Science"  @if(old('ssc_dept')=='Science') selected @endif > Science </option>
                        <option value="Commerce"  @if(old('ssc_dept')=='Commerce') selected @endif > Commerce </option>
                        <option value="Humanities"  @if(old('ssc_dept')=='Humanities') selected @endif > Humanities </option>
                       
                      </select>
                      </div>
                    </div>
                    
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>HSC Batch</label> 
                        <input type="number" min="1950" max="{{date('Y')}}" class="form-control" name="hsc_batch" placeholder="Enter..." value="{{$data->hsc_batch}}" >
                      </div>
                    </div>
                    
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>HSC Department</label> 
                        
                        <select class="form-control" name="hsc_dept" style="" >
                        <option value=""  @if(old('hsc_dept')=='') selected @endif > - </option>
                        <option value="Science"  @if(old('hsc_dept')=='Science') selected @endif > Science </option>
                        <option value="Commerce"  @if(old('hsc_dept')=='Commerce') selected @endif > Commerce </option>
                        <option value="Humanities"  @if(old('hsc_dept')=='Humanities') selected @endif > Humanities </option>
                       
                      </select>
                      

                      </div>
                    </div>
                    
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Present Occupation</label> 
                        <input type="text" class="form-control" name="present_job" placeholder="Enter..." value="{{$data->present_job}}" >
                      </div>
                    </div>
                    
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Job Position</label> 
                        <input type="text" class="form-control" name="present_designation" placeholder="Enter..." value="{{$data->present_designation}}" >
                      </div>
                    </div>
                    
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Office/Org Name</label> 
                        <input type="text" class="form-control" name="org_name" placeholder="Enter..." value="{{$data->org_name}}" >
                      </div>
                    </div>
                                  
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Mobile Number</label> 
                        <input type="text" class="form-control" name="mobile" placeholder="Enter..." value="{{$data->mobile}}" >
                      </div>
                    </div>
                    
                    @if(intval($data->birth_date)>0) @php  
                    $dd = date('d',strtotime($data->birth_date));  
                    $mm = date('m',strtotime($data->birth_date));  
                    $yy = date('Y',strtotime($data->birth_date)); 
                    @endphp  @endif
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Email ID</label> 
                        <input type="email" class="form-control" name="email" placeholder="Enter..." value="{{$data->email}}" >
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Date of Birth</label> <br>
                        <select class="form-control" name="bd" style="width:70px; margin:0 5px 0 0; float:left;" >
                            <option value=""> Day </option>
                            <?php 
                              for ($i=1; $i <=31 ; $i++) { 
                                if(@$dd==$i) $set1="selected"; else $set1 = "";
                                echo "<option value='".$i."' $set1 > ".$i." </option>";
                              }
                            ?>
                          </select>
            
                          <select class="form-control" name="bm" style="width:75px; margin:0 5px 0 0; float:left" >
                            <option value=""> Month </option>
                            <?php 
                              for ($i=1; $i <=12 ; $i++) { 
                                if(@$mm==$i) $set1="selected"; else $set1 = "";
                                echo "<option value='".$i."' $set1 > ".$i. date(' | F ',strtotime("2015-".$i."-01"))." </option>";
                              }
                            ?>
                          </select>
                          <input class="form-control" name="by" value="<?php echo @$yy; ?>" placeholder="YYYY" maxlength="4"  style="width:80px" pattern="[0-9]{4,4}" title="Only numaric number e.g. 2014,2015">
                        
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Blood Group</label> 
                        <select class="form-control" name="blood_group" style="" >
                        <option value=""  @if($data->blood_group=='') selected @endif > - </option>
                        <option value="A+"  @if($data->blood_group=='A+') selected @endif > A+ </option>
                        <option value="A−"  @if($data->blood_group=='A−') selected @endif > A− </option>
                        <option value="B+"  @if($data->blood_group=='B+') selected @endif > B+ </option>
                        <option value="B−"  @if($data->blood_group=='B−') selected @endif > B− </option>
                        <option value="AB+" @if($data->blood_group=='AB+') selected @endif > AB+ </option>
                        <option value="AB−" @if($data->blood_group=='AB−') selected @endif > AB− </option>
                        <option value="O+"  @if($data->blood_group=='O+') selected @endif  > O+ </option>
                        <option value="O−"  @if($data->blood_group=='O−') selected @endif  > O− </option>
                      </select>
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Reg Date </label> 
                        <div class="input-group date" id="date1" data-target-input="nearest">
                          <input type="text" name="reg_date" value="{{$data->reg_date}}" class="form-control datetimepicker-input" data-target="#date1"/>
                          <div class="input-group-append" data-target="#date1" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                          </div>
                        </div
                      </div>
                    </div>
                  </div>
                  
                  
                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Status</label> 
                        <select name="status" class="custom-select  form-control " required >
                            <option value="">Search - All</option>
                            <option value="1" @if($data->status==1) selected @endif>Active</option>
                            <option value="2" @if($data->status==2) selected @endif>Pending</option>
                            <option value="0" @if(isset($data->status) && $data->status==0) selected @endif>In-Active</option>
                          </select>
                      </div>
                    </div>

               
                <div class="col-md-6">
                </div>
                <div class="" align="right"> <br>
                  <button type="submit" class="btn btn-primary"> Save </button>
                </div>



                </form>
              </div>
              <!-- /.card-body -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->





@stop