@if(userCan('edoctument-list')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif

@extends('layouts.default')
@php $pageTitle = 'Document List'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('edoctument-list')>0)
              <li class="breadcrumb-item "><a href="/elibery/index"> eDocument List </a></li>
              @endif
              @if(userCan('edoctument-create')>0)
              <li class="breadcrumb-item active"><a href="/elibery/index/create"> Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

 @stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <!-- /.card -->

            <div class="card">
              <!-- <div class="card-header">
                <h3 class="card-title">Employee List</h3>
              </div> -->
              <!-- /.card-header -->
              <form method="" action="" role="form" >
                {{ csrf_field() }} 
                <div class="card-header">
                Per Page
                  <select name="limit" class="">
                      <option value="10" > 10 </option>
                      <option value="25">25</option>
                      <option value="50">50</option>
                      <option value="100">100</option>
                  </select>
                <div class="card-tools">
                  <div class="input-group" style="width: auto">
                    <input type="text" name="searchin"
                      class="form-control form-control-sm float-right"
                      placeholder="Search">
                    <div class="input-group-append ">
                      <!-- <label>Satus</label> -->
                      <select name="searchfor"
                        class="custom-select custom-select-sm form-control form-control-sm">
                        <option value="">Search - All</option>
                        <option value="1" >Active</option>
                        <option value="0" >In-Active</option>
                      </select>
                    </div>

                    <div class="input-group-append">
                      <button type="submit" class="btn btn-default btn-sm">
                        <i class="fas fa-search"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
              </form>




              <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap table-striped">
                  <thead>
                    <tr>
                      <th>Document Name & Type</th>
                      <th>Version No</th>
                      <th>Issue No</th>
                      <th>Created By</th>
                      <th>Updated By</th>
                      <th><i class="fa fa-paperclip fa-1x"></i> Type</th>
                      <th>Action</th>
                    </tr>   

                  </thead>
                  <tbody>
                    @foreach($datas as $key=>$data)
                    <tr>
                      <td>
                        {{$data->document_name}} <br> 
                        <span class="text-blue">{!!@documentTypeList($data->doc_type,1)!!} </span> 
                      </td>
                      <td>V-{{@$data->doc_version}}</td>
                      <td>{{@$data->issue_no}}</td>
                      <td>{{@$data->createUser->name}} <br> <span class="text-blue">{{date('d/m/Y h:iA',strtotime($data->created_at))}} </span> </td>
                      <td>{{@$data->updateUser->name}} <br> <span class="text-blue">{{date('d/m/Y h:iA',strtotime($data->updated_at))}} </span> </td>
                      <td>{{$data->file_type}} <br> <span class="text-blue">{{number_format($data->file_size/1024,2)}} MB</span></td>
                      



                      <td>
                        @if(userCan('edoctument-view')>0)
                        <a href="{{$data->filename}}"> <i class="fa fa-eye"></i></a>
                        @endif
                        @if(userCan('edoctument-edit')>0)
                        <a href="#/elibery/index/{{$data->id}}/edit"> <i class="fa fa-edit"></i></a>
                        <a href="{{$data->filename}}"> <i class="fa fa-download"></i></a>
                        @endif
                      </td>
                    </tr>



                  @endforeach
                    
                    
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->

<style>
  .list-img{width: 20%; height: auto;  float: left;  }
  .list-img img { border-radius: 50%; border:1px solid #fff; padding: 2px; height: auto; max-width: 100%; }
  img { vertical-align: middle; border-style: none;}
  .list-name{width: 79%; float: left; background: transparent; padding-right: 15px;}
</style>    
@stop