@extends('layouts.default')
@php $pageTitle = 'Employee List'; @endphp
@section('title',$pageTitle)
@section('PageHead')

<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              <li class="breadcrumb-item "><a href="?"> {{$pageTitle}} </a></li>
              <li class="breadcrumb-item active"><a href="empadd"> Add New </a></li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

 @stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <!-- /.card -->

            <div class="card">
              <!-- <div class="card-header">
                <h3 class="card-title">Employee List</h3>
              </div> -->
              <!-- /.card-header -->
              <form method="" action="" role="form" >
                {{ csrf_field() }} 
                <div class="card-header">
                Per Page
                  <select name="limit" class="">
                      <option value="10" > 10 </option>
                      <option value="25">25</option>
                      <option value="50">50</option>
                      <option value="100">100</option>
                  </select>
                <div class="card-tools">
                  <div class="input-group" style="width: auto">
                    <input type="text" name="searchin"
                      class="form-control form-control-sm float-right"
                      placeholder="Search">
                    <div class="input-group-append ">
                      <!-- <label>Satus</label> -->
                      <select name="searchfor"
                        class="custom-select custom-select-sm form-control form-control-sm">
                        <option value="">Search - All</option>
                        <option value="1" >Active</option>
                        <option value="0" >In-Active</option>
                      </select>
                    </div>

                    <div class="input-group-append">
                      <button type="submit" class="btn btn-default btn-sm">
                        <i class="fas fa-search"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
              </form>




              <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap table-striped">
                  <thead>
                    <tr>
                      <th >Staff</th>
                      <th>Designation</th>
                      <th>Mobile</th>
                      <th >Competency Gap</th>
                      <th>Status</th>
                      <th>Action</th>
                    </tr>   
 
                  </thead>
                  <tbody>
                    @for($i=1;$i<11;$i++)
                    <tr>
                      <td>
                        <div class="list-img"><img src="/img/user1-128x128.jpg"></div>
                        <div class="list-name">Abir Mahamud <br> <span class="text-blue">ITL001</span></div>
                      </td>
                      <td>Managing Director</td>
                      <td>01725455746 <br> <span class="text-blue">abir@techi365.com</span></td>
                      <td align="center">
                        <span class="badge bg-danger">Yes</span>
                        <div class="progress progress-xs">
                          <div class="progress-bar progress-bar-danger" style="width: 40%"></div>
                        </div>
                      </td>
                      <td>Active</td>
                      <td>
                        <a href="#"> <i class="fa fa-eye"></i></a>
                        <a href="/empEdit"> <i class="fa fa-edit"></i></a>
                        <a href="#"> <i class="fa fa-file-signature"></i></a>
                        <a href="#"> <i class="fa fa-address-book"></i></a>
                      </td>
                    </tr>


                    <tr>
                      <td>
                        <div class="list-img"><img src="/img/user8-128x128.jpg"></div>
                        <div class="list-name">Tahameed Alam <br> <span class="text-blue">ITL002</span></div>
                      </td>
                      <td>Managing Director</td>
                      <td>01725455746 <br> <span class="text-blue">tahameed@techi365.com</span></td>
                      <td align="center">
                        <span class="badge bg-danger">Yes</span>
                        <div class="progress progress-xs">
                          <div class="progress-bar progress-bar-danger" style="width: 60%"></div>
                        </div>
                      </td>
                      <td>Active</td>
                      <td>
                        <a href="#"> <i class="fa fa-eye"></i></a>
                        <a href="/empEdit"> <i class="fa fa-edit"></i></a>
                        <a href="#"> <i class="fa fa-file-signature"></i></a>
                        <a href="#"> <i class="fa fa-address-book"></i></a>
                      </td>
                    </tr>

                    <tr>
                      <td>
                        <div class="list-img"><img src="/img/user6-128x128.jpg"></div>
                        <div class="list-name">Atiqur Rahman Khan <br> <span class="text-blue">ITL003</span></div>
                      </td>
                      <td>Software Engineer</td>
                      <td>01725455746 <br> <span class="text-blue">atiqur@techi365.com</span></td>
                      <td align="center">
                        <span class="badge bg-danger">Yes</span>
                        <div class="progress progress-xs">
                          <div class="progress-bar progress-bar-danger" style="width: 90%"></div>
                        </div>
                      </td>
                      <td>Active</td>
                      <td>
                        <a href="#"> <i class="fa fa-eye"></i></a>
                        <a href="/empEdit"> <i class="fa fa-edit"></i></a>
                        <a href="#"> <i class="fa fa-file-signature"></i></a>
                        <a href="#"> <i class="fa fa-address-book"></i></a>
                      </td>

                    </tr>

                    @endfor
                    
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->

<style>
  .list-img{width: 20%; height: auto;  float: left;  }
  .list-img img { border-radius: 50%; border:1px solid #fff; padding: 2px; height: auto; max-width: 100%; }
  img { vertical-align: middle; border-style: none;}
  .list-name{width: 79%; float: left; background: transparent; padding-right: 15px;}
</style>    
@stop