@if(userCan('ChartOfAccounts-show')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'Account Quick Report'; @endphp
@section('title',$pageTitle)
@section('PageHead')


@php
 $Date1= app('request')->input('date1');
 $Date2= app('request')->input('date2');
 $client= app('request')->input('client');
 $doctor= app('request')->input('doctor');
 $type= app('request')->input('type');
 $status= app('request')->input('status'); 
 $perpage = ((app('request')->input('plimit'))>0) ? app('request')->input('plimit') : 5;
@endphp


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              <li class="breadcrumb-item"><a href="/Reports">Reports</a></li>
              <!-- <li class="breadcrumb-item"><a href="/settings/ChartOfAccounts">Chart of Account</a></li> -->
              <li class="breadcrumb-item "><a href="?"> {{$pageTitle}} </a></li>
              <li> &nbsp;  &nbsp; <i onclick="window.print()" class="fa fa-print fa-1x"></i>  </li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

 @stop

@section('content')

    
<section class="content">
    <div class="container-fluid card printHide">
        <form method="" action="" role="form" >
        <div class="row">

          <div class="col-md-4">
            Date <br>
            <div style="width:49%; float:left;" >
              <div class="input-group date" id="date1" data-target-input="nearest">
                <input type="text" name="date1" value="{{app('request')->input('date1')}}" class="form-control datetimepicker-input" data-target="#date1" autocomplete="off" />
                <div class="input-group-append" data-target="#date1" data-toggle="datetimepicker">
                  <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                </div>
              </div>
            </div>
              
            <div style="width:49%; float:right;" >
              <div class="input-group date" id="date2" data-target-input="nearest">
                <input type="text" name="date2" value="{{app('request')->input('date2')}}" class="form-control datetimepicker-input" data-target="#date2" autocomplete="off" />
                <div class="input-group-append" data-target="#date2" data-toggle="datetimepicker">
                  <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                </div>
              </div>
            </div>               
          </div>

            
            <div class="col-md-6">
              Account of 
              <select name="acc_id" class="custom-select custom-select-sm form-control form-control-sm select2">
                <option value=""> - </option>
                  {!!accounts_name(app('request')->input('acc_id'))!!}
              </select>
            </div>
            

            

         <!--  <div class="col-md-1">
              Per Page<br>
            <select name="plimit" class="form-control">
              {!! PerPageForSelectOption($perpage) !!}
            </select>
          </div> -->
            
            <div class="col-md-1">
                <br>
              <button type="submit" class="btn btn-default btn-sm">
                <i class="fas fa-search"></i>
              </button>
            </div>
            
          
        </div>
                    <input type="hidden" name="find_run" value="1010101010101010101010010101010101">
        <!--// row-->
        </form>
        <br>
    </div>
    <!--// container-fluid-->
</section>
<!--// end section-->


   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <!-- /.card -->

            <div class="card">
              <!-- <div class="card-header">
                <h3 class="card-title">Employee List</h3>
              </div>  -->
              <!-- /.card-header -->

              <div class="card-body table-responsive p-0">
                <div align="center">
                  <h2>{{ config('app.appFullName', 'Business Name') }}</h2>                  
                  Account QuickReport <br/>
                  @if(intval(@$info['date1'])>0)  Duration :
                    {{date('F d, Y',strtotime($info['date1']))}} to {{date('F d, Y',strtotime($info['date2']))}}  
                  @endif
                  <span class="print-on-date">Print On: {{date('d/m/Y h:iA')}}</span> 
                  <hr class="voucher0">
                </div>
@php $openingBalance = @$info['openingTotal']; $crTotal = $drTotal = $accBalance = 0; $accBalance += $openingBalance;  @endphp
                
                <!-- <table class="table table-head-fixed text-nowrap"> -->
                <!-- <table class="table table-hover "> -->
                <!-- <div class="card-body table-responsive p-0" style="height: 300px;"> -->
                <div class="card-body table-responsive p-0" >
                <table class="table table-head-fixed text-nowrap0">
                  <thead>
                    <tr>
                      <th>DATE</th>
                      <th>TRANS TYPE</th>
                      <th>VOUCHER</th>
                      <th width="150">NAME</th>
                      <th width="150">MEMO</th>
                      <th title="Sense {{@$info['sense']}}">ACCOUNT</th>
                      <th align="right">DEBIT</th>
                      <th align="right">CREDIT</th>
                      <th align="right">BALANCE  </th>
                    </tr>   
   
                  </thead>
                  <tbody>
                    <tr>
                      <td colspan="6">Begining Balance </td>                      
                      <td align="right"> <!-- number_format(@$info['total_dr'],2)}} --> </td>
                      <td align="right"> <!-- number_format(@$info['total_cr'],2)}} --> </td>
                      <td align="right">{{number_format($openingBalance,2)}}</td>
                    </tr>
                    @foreach(($datas) as $key=>$val)
                      <tr>
                        <td> {{date('d/m/Y',strtotime(@$val->transactions->transaction_date))}} </td>
                        <td>  {{@$val->transactions->tranType->type_name}} </td>
                        <td>{{$val->trans_id}}</td>
                        <td>
                          @if(@$val->transactions->pyee_type==1) 
                            {{@$val->transactions->vendor['code']}} - {{@$val->transactions->vendor['name']}} <br>
                            <small style="color: #99f">Vendor </small>
                            
                          @elseif(@$val->transactions->pyee_type==2)
                            {{@$val->transactions->customer['code']}} - {{@$val->transactions->customer['name']}} <br>
                            <small style="color: #99f">Customer </small>
                          @elseif(@$val->transactions->pyee_type==3)
                            {{@$val->transactions->staff['employee_id']}} - 
                            {{@$val->transactions->staff['full_name']}} {{@$val->transactions->staff['nick_name']}} <br>
                            <small style="color: #99f">Staff</small>
                          @endif
                        </td>
                        <td>{{@$val->transactions->memo_notes}}  </td>

                        @if($val->type==1)
                          @php $drTotal += $val->amount; 
                            if($info['sense']==1) {$accBalance += $val->amount; }
                            else if($info['sense']==2) {$accBalance -= $val->amount; }
                          @endphp
                        <td> {{@$val->dr_account_informations->account_name}} </td>
                        <td align="right">{{number_format($val->amount,2)}}</td>
                        <td> </td>
                        @endif
<!-- $accBalance -= $val->amount; -->
                        @if($val->type==2)
                          @php $crTotal += $val->amount;  
                            if($info['sense']==1) {$accBalance -= $val->amount; }
                            else if($info['sense']==2) {$accBalance += $val->amount; }
                          @endphp
                        <td> {{@$val->cr_account_informations->account_name}} </td>
                        <td> </td>
                        <td align="right">{{number_format($val->amount,2)}}</td>
                        @endif

                        <td align="right">{{number_format($accBalance,2)}}</td>
                      </tr>

                    @endforeach


                    <tr style="border-bottom:1px solid #999; ">
                      <td colspan="6">
                        <b>  Total for {{@$info['account_name']}} {{@$val->cr_account_informations->account_name}} {{@$val->dr_account_informations->account_name}} </b>
                      </td>                      
                      <td align="right" title="List data amount total "><b>{{number_format($drTotal,2)}}</b></td>
                      <td align="right" title="List data amount total "><b>{{number_format($crTotal,2)}}</b></td>
                      <td align="right" title="Account Balance, open:{{@$info['account_opening_balance']}}"><b>{{number_format($accBalance,2)}}</b></td>
                    </tr>
                                      
                  </tbody>
                </table>
                </div>
                <!-- for fixed table heigh -->
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
 
@stop