@if(userCan('ChartOfAccounts-show')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'Balance Sheet'; @endphp
@section('title',$pageTitle)
@section('PageHead')


@php
 $Date1= app('request')->input('date1');
 $Date2= app('request')->input('date2');
@endphp


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              <li class="breadcrumb-item"><a href="/Reports">Reports</a></li>
              <li class="breadcrumb-item "><a href="?"> {{$pageTitle}} </a></li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

 @stop

@section('content')


   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <!-- /.card -->

            <div class="card">
              <!-- <div class="card-header">
                <h3 class="card-title">Employee List</h3>
              </div>  -->
              <!-- /.card-header -->

              <div class="card-body table-sm p-0 accTreeText">
                <div align="center">
                  <h2>{{ config('app.appFullName', 'Business Name') }}</h2>                  
                  <h6>Balance Sheet<br/>
                  @if(intval(@$info['date1'])>0)  As of
                    {{date('F d, Y',strtotime($info['date1']))}}  
                  @endif
                </h6>
                  <span class="print-on-date">Print On: {{date('d/m/Y h:iA')}}</span> 
                 
                </div>
<!-- AccRootAccountByID(2)}}
foreach(AccRootAccountByID(2) as $root)
  $root->rootName}}
endforeach -->

                 <br>
@php 
  $rootTotal1 = $rootTotal2 = $rootTotal3 = $rootTotal4 = $rootTotal5 = $rootTotal6 = 0;
  $totalRoot = $totalType = $totalDetails = 0; 
@endphp

<!-- 
1 Application of Funds (Assets)
2 Source of Funds (Liabilities)
4 Income
5 Expense
6 Cost Of Goods Sold
 -->

                <table class="table table-sm no-border">
                  <tbody>
                    <tr class="accTreeTopBorder">
                      <td colspan="2" align="right">Total</td>
                    </tr>
                   
                    <!-- 1 Assets -->
                    @foreach(AccRootAccountByID(1) as $root)
                    @php  $totalRoot += $totalType = $totalDetails = $balance =  0; @endphp 
                    @if((RootAccountTypeBalance($root->rootID)) !=0)
                    <tr>
                      <td> 
                        {{$root->rootName}}
                      </td>
                      <td align="right" title="{{RootAccountTypeBalance($root->rootID)}} ">  </td>
                    </tr>
                        @foreach($root->AccountTypes as $type)
                        @if((TypeAccountBalance(@$type->account_type_ID)) !=0)
                        <tr>
                          <td> 
                            <div class="accTreePadding"> &nbsp; </div> 
                            <!-- {{@$type->account_type_ID}}   -->
                            {{@$type->account_type_name}}  </td>
                          <td align="right" title="{{TypeAccountBalance(@$type->account_type_ID)}}">   </td>
                        </tr>
                          @foreach($type->AccountDetailsTypes as $details)
                            @if((DetailsAccountBalance(@$details->detail_type_id)) !=0)

                          <tr>
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div>  
                              <div class="accTreePadding"> &nbsp; </div> 
                              {{@$details->detail_type_name}}  </td>
                            <td align="right" title="{{DetailsAccountBalance(@$details->detail_type_id)}}"> </td>
                          </tr>
                            @foreach($details->AccountName as $account)
                            
                              @if((@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total) !=0)

                              @php if($account->sense==1) {
                                 $balance = (@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total);
                               }
                              elseif($account->sense==2) {
                                $balance = (@$account->CrTotalByAccID->total - @$account->DrTotalByAccID->total);
                              }

                                // for opening balance add 
                                if(intval($account->account_opening_balance)>0) $balance += $account->account_opening_balance;
                                $totalRoot +=$balance;
                                $totalType +=$balance;
                                $totalDetails +=$balance;
                              @endphp

                              @php  //$totalRoot = $totalType = $totalDetails = 0; @endphp 
                            <tr>
                              <td> 
                                <div class="accTreePadding"> &nbsp; </div>  
                                <div class="accTreePadding"> &nbsp; </div> 
                                <div class="accTreePadding"> &nbsp; </div> 
                              <!-- {{@$account->account_number}}   -->
                              {{@$account->account_name}}  </td>
                              <td align="right" title="{{$account->sense==1}} DR: {{@$account->DrTotalByAccID->total}}, CR: {{@$account->CrTotalByAccID->total}}, Open: {{intval($account->account_opening_balance)}} " > 
                                {{number_format($balance,2)}}
                              </td>
                            </tr>
                            @endif
                            <!-- end account -->
                            @endforeach

                          <tr class="accTreeBorder" >
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div>  
                              <div class="accTreePadding"> &nbsp; </div> 
                              <b> Total {{@$details->detail_type_name}}   </b></td>
                            <td align="right">  <b>{{number_format($totalDetails,2)}} </b></td>
                          </tr>

                        <tr>
                          <td colspan="2">  </td>
                        </tr>

                          @php  $totalDetails = $balance =  0; @endphp 
                            @endif 
                            <!-- end details -->
                          @endforeach

                          <tr class="accTreeBorder" >
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div>  
                              <b> Total {{@$type->account_type_name}}  </b></td>
                            <td align="right">  <b>{{number_format($totalType,2)}} </b></td>
                          </tr>

                        <tr>
                          <td colspan="2">  </td>
                        </tr>
                          @php  $totalType = $totalDetails = $balance =  0; @endphp 
                          @endif

                          <!-- end type -->
                        @endforeach



                        <tr class="accTreeBorder2" >
                            <td> 
                              <div class="accHeadTitle"> Total {{$root->rootName}}  </div></td>
                            <td align="right">  <b>{{number_format($totalRoot,2)}} </b></td>
                          </tr>
                        @php $rootTotal1 = $totalRoot;  $totalRoot =  0; @endphp 
                      @endif
                      <!-- end root -->
                    @endforeach
                    
                    <!-- 1  end Assets -->





                    <tr>
                      <td colspan="2">  </td>
                    </tr>

                    <!-- 2 Liabilities -->
                    @foreach(AccRootAccountByID(2) as $root)
                    @php  $totalRoot += $totalType = $totalDetails = $balance =  0; @endphp 
                    @if((RootAccountTypeBalance($root->rootID)) !=0)
                    <tr>
                      <td> 
                        {{$root->rootName}}

                      </td>
                      <td align="right" title="{{RootAccountTypeBalance($root->rootID)}} ">  </td>
                    </tr>
                        @foreach($root->AccountTypes as $type)
                        @if((TypeAccountBalance(@$type->account_type_ID)) !=0)
                        <tr>
                          <td> 
                            <div class="accTreePadding"> &nbsp; </div> 
                            <!-- {{@$type->account_type_ID}}   -->
                            {{@$type->account_type_name}}  </td>
                          <td align="right" title="{{TypeAccountBalance(@$type->account_type_ID)}}">   </td>
                        </tr>
                          @foreach($type->AccountDetailsTypes as $details)
                            @if((DetailsAccountBalance(@$details->detail_type_id)) !=0)

                          <tr>
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div>  
                              <div class="accTreePadding"> &nbsp; </div> 
                              {{@$details->detail_type_name}}  </td>
                            <td align="right" title="{{DetailsAccountBalance(@$details->detail_type_id)}}"> </td>
                          </tr>
                            @foreach($details->AccountName as $account)
                              @if((@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total) !=0)

                              @php if($account->sense==1) 
                                 $balance = (@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total);
                              elseif($account->sense==2) 
                                $balance = (@$account->CrTotalByAccID->total - @$account->DrTotalByAccID->total);

                                // for opening balance add 
                                if(intval($account->account_opening_balance)>0) $balance += $account->account_opening_balance;
                                $totalRoot +=$balance;
                                $totalType +=$balance;
                                $totalDetails +=$balance;
                              @endphp

                              @php  //$totalRoot = $totalType = $totalDetails = 0; @endphp 
                            <tr>
                              <td> 
                                <div class="accTreePadding"> &nbsp; </div>  
                                <div class="accTreePadding"> &nbsp; </div> 
                                <div class="accTreePadding"> &nbsp; </div> 
                              <!-- {{@$account->account_number}}   -->
                              {{@$account->account_name}}  </td>
                              <td align="right" title="{{$account->sense==1}} DR: {{@$account->DrTotalByAccID->total}}, CR: {{@$account->CrTotalByAccID->total}}, Open: {{intval($account->account_opening_balance)}}" > 
                                {{number_format($balance,2)}}
                              </td>
                            </tr>
                            @endif
                            <!-- end account -->
                            @endforeach

                          <tr class="accTreeBorder" >
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div>  
                              <div class="accTreePadding"> &nbsp; </div> 
                              <b> Total {{@$details->detail_type_name}}   </b></td>
                            <td align="right">  <b>{{number_format($totalDetails,2)}} </b></td>
                          </tr>

                          <!-- line gap -->
                          <tr><td colspan="2"> </td></tr>

                          @php  $totalDetails = $balance =  0; @endphp 
                            @endif 
                            <!-- end details -->
                          @endforeach

                          <tr class="accTreeBorder" >
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div>  
                              <b> Total {{@$type->account_type_name}}  </b></td>
                            <td align="right">  <b>{{number_format($totalType,2)}} </b></td>
                          </tr>
                          <!-- line gap -->
                          <tr><td colspan="2"> </td></tr>
                          @php  $totalType = $totalDetails = $balance =  0; @endphp 
                          @endif
                          <!-- end type -->
                        @endforeach

                        <tr class="accTreeBorder" >
                            <td> 
                              <b> Total {{$root->rootName}}  </b></td>
                            <td align="right">  <b>{{number_format($totalRoot,2)}} </b></td>
                          </tr>
                        @php $rootTotal2 = $totalRoot; $totalRoot =  0; @endphp 
                      @endif
                      <!-- end root -->
                    @endforeach
                    
                    <!-- end 2 Liabilities -->

                    <!-- line gap -->
                    <tr><td colspan="2"> </td></tr>


                    <!-- 3 Equity -->
                    @foreach(AccRootAccountByID(3) as $root)
                    @php  $totalRoot += $totalType = $totalDetails = $balance =  0; $invest = $draw = 0; @endphp 
                    @if((RootAccountTypeBalance($root->rootID)) !=0)
                    
                        @foreach($root->AccountTypes as $type)
                        @if((TypeAccountBalance(@$type->account_type_ID)) !=0)
                        
                          @foreach($type->AccountDetailsTypes as $details)
                            @if((DetailsAccountBalance(@$details->detail_type_id)) !=0)

                            @foreach($details->AccountName as $account)
                              @if((@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total) !=0)

                              @php if($account->sense==1) 
                                 $balance = (@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total);
                              elseif($account->sense==2) 
                                $balance = (@$account->CrTotalByAccID->total - @$account->DrTotalByAccID->total);

                                // for opening balance add 
                                if(intval($account->account_opening_balance)>0) $balance += $account->account_opening_balance;
                                $totalRoot +=$balance;
                                $totalType +=$balance;
                                $totalDetails +=$balance;

                              @endphp

                              @php  //$totalRoot = $totalType = $totalDetails = 0; @endphp 
                          
                            @endif
                            <!-- end account -->
                            @endforeach

                          @php  
                            if($invest==0 && $draw==0){ $invest = $totalDetails; $draw = 0; }  
                            else if($draw==0){ $draw = $totalDetails; }  
                            $totalDetails = $balance =  0; 
                          @endphp 
                            @endif 
                            <!-- end details -->
                          @endforeach

                          <!-- <tr class="accTreeBorder" >
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div>  
                              <b> Total {{@$type->account_type_name}}  </b></td>
                            <td align="right">  <b>{{number_format($invest-$draw,2)}} </b> $totalType  </td>
                          </tr> -->
                          @php  $totalType = $totalDetails = $balance =  0; @endphp 
                          @endif
                          <!-- end type -->
                        @endforeach

                        @php $totalRoot = $invest-$draw; @endphp
                        
                        @php $rootTotal3 = $totalRoot; $totalRoot =  0; @endphp 
                      @endif
                      <!-- end root -->
                    @endforeach
                    
                    <!-- end 3 Equity -->


                    <!-- 4 Income  -->
                    @foreach(AccRootAccountByID(4) as $root)
                    @php  $totalRoot += $totalType = $totalDetails = $balance =  0; @endphp 
                    @if((RootAccountTypeBalance($root->rootID)) !=0)
                    
                        @foreach($root->AccountTypes as $type)
                        @if((TypeAccountBalance(@$type->account_type_ID)) !=0)
                        
                          @foreach($type->AccountDetailsTypes as $details)
                            @if((DetailsAccountBalance(@$details->detail_type_id)) !=0)

                            @foreach($details->AccountName as $account)
                              @if((@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total) !=0)

                              @php if($account->sense==1) 
                                 $balance = (@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total);
                              elseif($account->sense==2) 
                                $balance = (@$account->CrTotalByAccID->total - @$account->DrTotalByAccID->total);

                                // for opening balance add 
                                if(intval($account->account_opening_balance)>0) $balance += $account->account_opening_balance;
                                $totalRoot +=$balance;
                                $totalType +=$balance;
                                $totalDetails +=$balance;
                              @endphp

                              @php  //$totalRoot = $totalType = $totalDetails = 0; @endphp 
                            
                            @endif
                            <!-- end account -->
                            @endforeach

                          
                          @php  $totalDetails = $balance =  0; @endphp 
                            @endif 
                            <!-- end details -->
                          @endforeach

                         
                          @php  $totalType = $totalDetails = $balance =  0; @endphp 
                          @endif
                          <!-- end type -->
                        @endforeach

                        
                        @php $rootTotal4 = $totalRoot; $totalRoot =  0; @endphp 
                      @endif
                      <!-- end root -->
                    @endforeach
                    
                    <!-- end 4 Income -->


                    <!-- 5 Expense -->
                    @foreach(AccRootAccountByID(5) as $root)
                    @php  $totalRoot += $totalType = $totalDetails = $balance =  0; @endphp 
                    @if((RootAccountTypeBalance($root->rootID)) !=0)
                    
                        @foreach($root->AccountTypes as $type)
                        @if((TypeAccountBalance(@$type->account_type_ID)) !=0)
                        
                          @foreach($type->AccountDetailsTypes as $details)
                            @if((DetailsAccountBalance(@$details->detail_type_id)) !=0)

                          
                            @foreach($details->AccountName as $account)
                              @if((@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total) !=0)

                              @php if($account->sense==1) 
                                 $balance = (@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total);
                              elseif($account->sense==2) 
                                $balance = (@$account->CrTotalByAccID->total - @$account->DrTotalByAccID->total);

                                // for opening balance add 
                                if(intval($account->account_opening_balance)>0) $balance += $account->account_opening_balance;
                                $totalRoot +=$balance;
                                $totalType +=$balance;
                                $totalDetails +=$balance;
                              @endphp

                              @php  //$totalRoot = $totalType = $totalDetails = 0; @endphp 
                           
                            @endif
                            <!-- end account -->
                            @endforeach

                         
                          @php  $totalDetails = $balance =  0; @endphp 
                            @endif 
                            <!-- end details -->
                          @endforeach

                          
                          @php  $totalType = $totalDetails = $balance =  0; @endphp 
                          @endif
                          <!-- end type -->
                        @endforeach

                        
                        @php $rootTotal5 = $totalRoot; $totalRoot =  0; @endphp 
                      @endif
                      <!-- end root -->
                    @endforeach
                    
                    <!-- end 5 Expense -->

                    <!-- 6 Cost of good sold -->
                    @foreach(AccRootAccountByID(6) as $root)
                    @php  $totalRoot += $totalType = $totalDetails = $balance =  0; @endphp 
                    @if((RootAccountTypeBalance($root->rootID)) !=0)
                     
                        @foreach($root->AccountTypes as $type)
                        @if((TypeAccountBalance(@$type->account_type_ID)) !=0)
                         
                          @foreach($type->AccountDetailsTypes as $details)
                            @if((DetailsAccountBalance(@$details->detail_type_id)) !=0)

                           
                            @foreach($details->AccountName as $account)
                              @if((@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total) !=0)

                              @php if($account->sense==1) 
                                 $balance = (@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total);
                              elseif($account->sense==2) 
                                $balance = (@$account->CrTotalByAccID->total - @$account->DrTotalByAccID->total);

                                // for opening balance add 
                                if(intval($account->account_opening_balance)>0) $balance += $account->account_opening_balance;
                                $totalRoot +=$balance;
                                $totalType +=$balance;
                                $totalDetails +=$balance;
                              @endphp

                              @php  //$totalRoot = $totalType = $totalDetails = 0; @endphp 
                            
                            @endif
                            <!-- end account -->
                            @endforeach

                          
                          @php  $totalDetails = $balance =  0; @endphp 
                            @endif 
                            <!-- end details -->
                          @endforeach

                           
                          @php  $totalType = $totalDetails = $balance =  0; @endphp 
                          @endif
                          <!-- end type -->
                        @endforeach

                         
                        @php $rootTotal6 = $totalRoot; $totalRoot =  0; @endphp 
                      @endif
                      <!-- end root -->
                    @endforeach
                    
                    <!-- end 6 Cost of Good Sold -->





              @php $netIncome = $rootTotal4-$rootTotal5-$rootTotal6 @endphp
 
                                       
                    
                    <tr>
                      <td> 
                         Equity 
                      </td>
                      <td align="right"   > 
                        
                      </td>
                    </tr>

                    <tr>
                      <td> 
                        <div class="accTreePadding"> &nbsp; </div> 
                        Owner's Equity 
                      </td>
                      <td align="right"   > 
                        {{number_format($rootTotal3,2)}}
                      </td>
                    </tr>
                    <tr>
                      <td> 
                        <div class="accTreePadding"> &nbsp; </div> 
                        Profit and Loss (A/C) 
                      </td>
                      <td align="right"   > 
                        {{number_format($netIncome,2)}}
                      </td>
                    </tr>
                  
                    <tr class="accTreeBorder2" >
                        <td> 
                          <div class="accHeadTitle"> Total Liabilities and Owner's Equity  </b></td>
                        <td align="right">  <b>{{number_format($rootTotal2+$rootTotal3+$netIncome,2)}} </b></td>
                      </tr>

                  </tbody>
                </table>

               
            <!--       <hr>
            <div class="row">
              <div class="col-md-6">
              Application of Funds (Assets)   = <b><u>{{$rootTotal1}}</u></b> <br>                                  
            </div>

            <div class="col-md-6">
              Source of Funds (Liabilities)   = {{$rootTotal2}} <br>
              Equity   = {{$rootTotal3}} <br>
              Income   = {{$rootTotal4}} <br>
              Expense   = {{$rootTotal5}} <br>
              Cost Of Goods Sold   = {{$rootTotal6}} <br>
              Net Income  = {{$netIncome}} <br>
              <b><u>{{$rootTotal2+$rootTotal3+$netIncome}}</u></b>
              </div>
            </div>
 
                              <hr> -->

              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
 
@stop