@if(userCan('ConfirmationApproval-create')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'New Confirmation'; @endphp
@section('title',$pageTitle)
@section('PageHead')


@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}} - {{@$data->full_name}} <small style="color: blue;">{{@$data->nick_name}}</small></h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              
              @if(userCan('ConfirmationApproval-List')>0)
              <li class="breadcrumb-item "><a href="/Confirmation/ConfirmationApproval"> Confirmation Approval List </a></li>
              @endif
              
            </ol>         
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
@stop
<style>
  .nav-link{padding: .5rem 8px !important; }
  .nav-tabs .nav-link { border-right: 1px solid #bbb5b5 !important;}
</style>
@section('content')
    <!-- Main content -->

<section class="content">
  <div class="container-fluid">
    <div class="row">
      <!-- /.col -->
      <div class="col-md-12">
        <div class="card-body">

          <div class="row">
          <div class="col-12 col-sm-12">
            <div class="card card-primary card-tabs">
              <div class="card-header p-0 pt-1">
                <ul class="nav nav-tabs" id="custom-tabs-one-tab" role="tablist">
                  
                  <li class="nav-item">
                    <a class="nav-link active" id="Confirmation-tab" data-toggle="pill" href="#Confirmation" role="tab" aria-controls="Confirmation" aria-selected="true">Confirmation Details</a>
                  </li>
                  <li class="nav-item">
                    <a class="nav-link" id="History-tab" data-toggle="pill" href="#History" role="tab" aria-controls="History" aria-selected="false">History</a>
                  </li>
                                    
                </ul>
              </div>



              <div class="card-body">
                <div class="tab-content" id="custom-tabs-one-tabContent">

                  <div class="tab-pane fade show active" id="Confirmation" role="tabpanel" aria-labelledby="Confirmation-tab">
                  
                  <form method="POST" action="/Confirmation/ConfirmationApproval/store" role="form" id=""enctype="multipart/form-data">
                 {{ csrf_field() }}
                 @method('PUT')
                 <input type="hidden" name="id" value="{{$data->id}}">
                 <input type="hidden" name="url" value="{{URL::previous()}}">
           
                  <div class="row">
                   
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Staff</label>
                        <input hidden type="text" class="form-control" name="employee_id" value="{{@$data->employee_id}}" id="">
                        <input readonly type="text" class="form-control" name="" value="{{@$data->empInfo->full_name}}" id="">
                      </div>
                    </div>


                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Company</label>
                        <input hidden type="text" class="form-control" name="company_id" value="{{@$data->company_id}}" id="">

                        <input readonly type="text" class="form-control" name="" value="{{@$data->EmpCompanyName->name}}" id="">
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Designation</label>
                        <input hidden type="text" class="form-control" name="designation_id" value="{{@$data->designation_id}}" id="">
                        <input readonly type="text" class="form-control" name="" value="{{@$data->empDesignation->designation}}" id="">
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Department</label>
                        <input hidden type="text" class="form-control" name="dept_id" value="{{@$data->dept_id}}" id="">
                        <input readonly type="text" class="form-control" name="" value="{{@$data->empDepartment->department}}" id="">
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Joining Date</label>
                        <input readonly type="text" class="form-control" name="" value="{{@$data->empInfo->joining_date}}" id="">
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Confirmation Date</label>
                        <input readonly type="text" class="form-control" name="confirmation_date" value="{{@$data->confirmation_date}}" id="">
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Line Manager</label>
                        <input type="text" class="form-control" name="name" value="" id="">
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Head of Department</label>
                        <input type="text" class="form-control" name="name" value="" id="">
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Status</label>

                        <input readonly type="text" class="form-control" name="" value="{!!empType(@$data->employment_type)!!}" id="">
                      </div>
                    </div>


                  </div>
                 <!-- /end row -->
                    
                 <hr>
                   
                  <div class="row"> 

                    <div class="col-md-3">
                        <div class="form-group">
                          <label>Load Question</label>
                          <select class="form-control" name="staff_id" >
                            <option value="">Select One</option>
                            MMH
                          </select>
                        </div>
                    </div>

                    <div class="col-12 col-sm-3">
                      <br>
                      <div class="card card-primary card-tabs">
                         <div class="card-header p-0 pt-1">
                          <ul class="nav nav-tabs" id="custom-tabs-one-tab" role="tablist">
                            <li class="nav-item">
                              <a class="nav-link" id="Personal-tab" data-toggle="pill" href="#" aria-controls="Personal" aria-selected="true">Load</a>
                            </li>
                            <li class="nav-item">
                              <a class="nav-link" id="contact-tab" data-toggle="pill" href="#" aria-controls="contact" aria-selected="false">Add Question</a>
                            </li>             
                          </ul>
                        </div>
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Total Marks:</label>
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Marks Achieve:</label>
                      </div>
                    </div>

                  </div>
                 <!-- /end row -->

                  <div class="row">
                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Question No</label>
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Type</label>
                      </div>
                    </div>

                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Question</label>
                      </div>
                    </div>

                    <div class="col-md-1">
                      <div class="form-group">
                        <label>Weight</label>
                      </div>
                    </div>

                    <div class="col-md-1">
                      <div class="form-group">
                        <label>Marks</label>
                      </div>
                    </div>

                  </div>
                  <!-- end row -->

                  @for($i=1; $i<=3; $i++)
                  <div class="row">

                    <div class="col-md-2">
                      <div class="form-group">
                        {{$i}}
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <select class="form-control" name="q_type_id[]" >
                          <option value="">Select One</option>
                          MMH
                        </select>
                      </div>
                    </div>

                    <div class="col-md-6">
                      <div class="form-group">
                        <input type="text" class="form-control" name="question[]" value="" >
                      </div>
                    </div>

                    <div class="col-md-1">
                      <div class="form-group">
                        <input type="text" class="form-control" name="weight[]" value="" >
                      </div>
                    </div>

                    <div class="col-md-1">
                      <div class="form-group">
                        <input type="text" class="form-control" name="marks[]" value="" >
                      </div>
                    </div>
                    </div>
                  <!-- end row -->
                  @endfor

                  <div class="row">
                  <form>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Recommendation</label><br>
                        <label> <input disabled type="radio" name="recommend_is" value="1" {{ ($data->recommend_is=="1")? "checked" : "" }}> &nbsp;May Parmanent</label><br>
                        <label> <input disabled type="radio" name="recommend_is" value="2" {{ ($data->recommend_is=="2")? "checked" : "" }}> &nbsp;May Extent</label><br>
                        <label> <input disabled type="radio" name="recommend_is" value="3" {{ ($data->recommend_is=="3")? "checked" : "" }}> &nbsp;May Terminate</label>
                      </div>
                    </div>
                  </form>
                  

                    
                  <div class="col-md-2">
                    <div class="form-group">
                      <label>Salary Increase</label><br>
                      <label><input disabled type="radio" name="type" value="1">&nbsp;No</label><br><label><input disabled type="radio" name="type" value="2">&nbsp;Yes</label>
                    </div>
                  </div>
                    
                    


                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Current Salary</label>
                        <input readonly type="text" name="type" value="{{@$data->current_salary}}" class="form-control">
                        <label>Recommended Salary</label>
                        <input readonly type="text" name="name" value="{{@$data->recommended_salary}}" class="form-control">
                        
                      </div>
                    </div>

                    <div class="col-md-5">
                      <div class="form-group">
                        <label>Recommender Comments</label>
                        <textarea readonly class="form-control" name="recommend_comment" placeholder="Enter..." rows="4">{{@$data->recommend_comment}}</textarea>
                      </div>
                    </div>

               
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Approval</label><br>
                        <label> <input type="radio" name="approve_is" id="2" value="2" {{ ($data->approve_is=="2")? "checked" : "" }}>&nbsp;Parmanent</label>
                        <label> <input type="radio" name="approve_is" id="1" value="1" {{ ($data->approve_is=="1")? "checked" : "" }}>&nbsp;Probation Extended</label>
                        <label> <input type="radio" name="approve_is" id="6" value="6" {{ ($data->approve_is=="6")? "checked" : "" }}>&nbsp;Terminated</label>
                      </div>
                    </div>
                  
                  
                  
                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Approved Salary</label>
                        <input type="text" name="approved_salary" value="{{@$data->approved_salary}}" class="form-control">
                        <label>Probation Extended(Month)</label>
                        <input disabled="disabled" type="text" name="probation_ext" id="probation_ext" value="" class="form-control">
                        
                      </div>
                    </div>

                    <div class="col-md-5">
                      <div class="form-group">
                        <label>Approver Comments</label>
                        <textarea class="form-control" name="approve_comment" placeholder="Enter..." rows="4">{{@$data->approve_comment}}</textarea>
                      </div>
                    </div>

                 

                  <div class="col-md-12">
                    <br>
                    <div class="" align="right">
                      <button type="submit" class="btn btn-primary"> Save </button>
                    </div>
                  </div>

                  </div>
                <!-- end row -->

                </form>
                  
              </div>
                  <!-- end Confirmation-->



              <div class="tab-pane fade" id="History" role="tabpanel" aria-labelledby="History-tab">
                <div class="card-body table-responsive p-0 textCapital">
                  <table class="table table-hover  table-striped">

                    <thead>
                      <tr>
                        <th >History</th>
                      </tr>   
   
                    </thead>
                    <tbody>
                    
                      <tr>
                        <td>
                          <!-- {{@$data->apply_date}} Confirmation Created by {{$data->full_name}}
                          <br>

                          @if(intval(@$data->is_recommend)==1){{@$data->recommend_date}} Recommended by {{$data->recommend_user_name->name}}
                          @elseif(intval(@$data->is_recommend)==2){{@$data->recommend_date}}Not recommended by {{$data->recommend_user_name->name}}
                          @else
                           Recommendetion Pending
                          @endif
                          <br>

                          @if(intval(@$data->is_approved)==1){{@$data->approved_date}} Approved by {{$data->approved_user_name->name}}
                          @elseif(intval(@$data->is_approved)==2) {{@$data->approved_date}} Not-Approved by {{$data->approved_user_name->name}}
                          @elseif(intval(@$data->is_recommend)==1 && intval(@$data->is_approved)==0) Approve Pending
                          @endif -->
                        </td>
                      </tr>
                    
                    </tbody>
                  </table>
                </div>
                <!-- /.card-body -->

              </div>
              <!-- end History-->

           

                </div>
              </div>
              <!-- /.card -->
            </div>
          </div>
        </div>
        <!-- row -->


        </div>
      </div>
    </div>
  </div>
</section>

<script src="public/js/custom.js"></script>
<!-- <script type="text/javascript"></script> -->

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<script type="text/javascript">
  $(function(){
    $("input[name='approve_is']").click(function(){
      if ($("#1").is(":checked")) {
        $("#probation_ext").removeAttr("disabled");
        $("#probation_ext").focus();
      }
      else{
        $("#probation_ext").attr("disabled", "disabled");
      }
    });
  });
</script>
@stop