
@extends('app.layout')
@section('content')
@inject('Cfunc', 'App\CommonFunction\CommonFunction')
<section class="content-header" style="padding: 15px 0 10px 0">
    <h1>Dashboard</h1>
    <ol class="breadcrumb">
        <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active"><a href="/Authentication/Users/List">Users</a></li>
    </ol>
</section>


@if ( session('massage') )
<section >
    <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
        <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
        <strong>Success!</strong> {{session('massage')}}
    </div>
</section>
@endif
<div class="box box-primary">
  <div class="box-header">
    <h3 class="box-title">Update User</h3>
  </div>
  <form method="POST" action="/Authentication/User/Password/Change/{{$user->id}}">
    {{ csrf_field() }}
    {{ method_field('PATCH') }}
      <!-- /.box-header -->
      <div class="box-body">
        <div class="row{{ $errors->has('name') ? ' has-error' : '' }}">
            <div class="col-md-6">
            <label for="name" class="w3-slim w3-small w3-text-green">Name <span style="color: red" title="Required">*</span></label>

                <input id="name" type="text" class="form-control" name="name" value="{{ $user->name }}" required readonly>

                @if ($errors->has('name'))
                <span class="help-block">
                    <strong>{{ $errors->first('name') }}</strong>
                </span>
                @endif
            </div>
        </div>
        <div class="clearfix">&nbsp;</div>

        <div class="row">

            <div class="col-md-6 {{ $errors->has('password') ? ' has-error' : '' }}">
                <label for="password" class="w3-slim w3-small w3-text-green">Password <span style="color: red" title="Required">*</span></label>

                <input id="password" type="password" class="form-control" name="password" required autofocus>
                @if ($errors->has('password'))
                <span class="help-block">
                    <strong>{{ $errors->first('password') }}</strong>
                </span>
                @endif
            </div>

             <div class="col-md-6 {{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                <label for="password-confirm" class="w3-slim w3-small w3-text-green">Confirm Password <span style="color: red" title="Required">*</span></label>

                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required>
                @if ($errors->has('password_confirmation'))
                <span class="help-block">
                    <strong>{{ $errors->first('password_confirmation') }}</strong>
                </span>
                @endif
            </div>
        </div>
      </div>
    <div class="box-footer">
      <button type="submit" class="btn btn-primary">Update</button>
    </div>
    </form>
  <!-- /.box-body -->

</div>
<!-- /.box -->

<!-- box-end -->

@endsection
