
@extends('app.layout')
@section('title', 'Update User')
@section('content')
@inject('Cfunc', 'App\CommonFunction\CommonFunction')
<section class="content-header" style="padding: 15px 0 10px 0">
  <h1>Dashboard</h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active"><a href="/Authentication/Users/List">Users</a></li>
  </ol>
</section>


@if ( session('massage') )
<section >
  <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif

<div class="box box-primary">
  <div class="box-header">
    <h3 class="box-title">Update User</h3>
  </div>
  <!-- /.box-header -->
  <form method="POST" action="/Authentication/Users/List/{{$user->id}}">
    <div class="box-body">
    {{ csrf_field() }}
    {{ method_field('PATCH') }}

    <div class="row">
      <div class="col-md-6 {{ $errors->has('email') ? ' has-error' : '' }} ">
        <div class="from-group">
          <label for="name">Name <span style="color: red" title="Required">*</span></label>

          <input id="name" type="text" class="form-control " name="name" value="{{ $user->name }}" required autofocus="off" autocomplete="off">

          @if ($errors->has('name'))
          <span class="help-block">
            <strong>{{ $errors->first('name') }}</strong>
          </span>
          @endif
        </div>
      </div>
      <div class="col-md-6 {{ $errors->has('email') ? ' has-error' : '' }}">
        <div class="from-group">
          <label for="email" >E-Mail Address <span style="color: red" title="Required">*</span></label>
          <input id="email" type="email"  name="email" value="{{ $user->email }}" required class="form-control " autocomplete="off">
          @if ($errors->has('email'))
          <span class="help-block">
            <strong>{{ $errors->first('email') }}</strong>
          </span>
          @endif
        </div>
      </div>
    </div>

   

    <div class="row ">

      <div class="col-md-6 {{ $errors->has('password') ? ' has-error' : '' }}">
        <div class="form-group">
          <label for="password" >Password <span style="color: red" title="Required">*</span></label>
          <input id="password" type="password"  name="password" class="form-control " autocomplete="off">
          @if ($errors->has('password'))
          <span class="help-block">
            <strong>{{ $errors->first('password') }}</strong>
          </span>
          @endif
        </div>
      </div>
      <div class="col-md-6 {{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
        <div class="from-group">
          <label for="password-confirm" >Confirm Password <span style="color: red" title="Required">*</span></label>

          <input id="password-confirm" type="password" name="password_confirmation"  autocomplete="off"  class="form-control ">
          @if ($errors->has('password_confirmation'))
          <span class="help-block">
            <strong>{{ $errors->first('password_confirmation') }}</strong>
          </span>
          @endif
        </div>
      </div>
    </div>

    <div class="row">

      <div class="col-md-4">
        <div class="form-group">
          <label for="role_id" >User Type </label>
          <select name="user_type" class="form-control" required>
            <option value="">-</option>
            {!!$Cfunc->user_type_list(@$user->user_type)!!}
          </select>
        </div>
      </div>

      <!-- <div class="col-md-4">
        <div class="form-group">
          <label for="office_id" >Origin Office </label>
          <select name="office_id" id="office_id"  class="form-control " required>
            <option value="">Select One</option>
            $Cfunc->origdest_options($user->office_id)
          </select>
        </div>
      </div> -->

      <div class="col-md-4">
        <div class="form-group">
          <label for="status" >Status <span style="color: red" title="Required">*</span></label>
          <select name="status" id="status"  required class="form-control" autocomplete="off">
            <option value="">Select One</option>
            {!! $Cfunc->statusForSelectOption($user->status) !!}
          </select>
        </div>
      </div>
    </div>

  </div>
  <!-- /.box-body -->
   <div class="box-footer">
    <button type="submit" class="btn btn-primary">
                Update 
            </button>
    </div>
</form>

</div>
<!-- /.box -->
<!-- box-end -->

@endsection
