@extends('app.layout')
@section('content')
@inject('Cfunc', 'App\CommonFunction\CommonFunction')
<style>	
		.span-styleing{
			background-color: #3c8dbc;
    border-color: #367fa9;
    padding: 5px 5px;
    color: #fff;
    border-radius: 4px;
		}
</style>
<section class="content-header" style="padding: 15px 0 10px 0">
	<h1>Dashboard</h1>
	<ol class="breadcrumb">
		<li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
		<li class="active"><a href="/Authentication/Role/List">Role</a></li>
		<li class="active"><a href="/Authentication/Role/List/Add/New">Create Role</a></li>
	</ol>
</section>
@if ( session('massage') )
<section >
	<div class="alert alert-success alert-dismissable remove-button-after-3-sec">
		<a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
		<strong>Success!</strong> {{session('massage')}}
	</div>
</section>
@endif
<div class="box box-primary">
  <div class="box-header">
    <h3 class="box-title">Role list</h3>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
    <table id="example1" class="table table-bordered table-striped">
      <thead>
        <tr>
			<th >Name</th>
			<th >Display Name</th>
			<th>Permissions</th>
			<th>Action</th>
        </tr>
      </thead>
      <tbody>
       @foreach($roles as $key => $role)
        <tr>
			<td >{{ $role->name }}</td>
			<td   >{{ $role->display_name }}</td>
			<td >
				@if( count($role->permissions) > 0 )
					@foreach($role->permissions as $permission)
						<span class="span-styleing">{{$permission->name}}</span>
					@endforeach
				@endif
			</td>
			<td>
			@php 
			$link = '/Authentication/Role/List/'.$role->id.'/Edit';
			@endphp
			{!! $Cfunc->edit_link($link) !!}
			</td>
        
        </tr>
       @endforeach
       
      </tbody>
    </table>
  </div>
  <!-- /.box-body -->
   <div class="box-footer">
  	{{ $roles->links() }}
  </div>
</div>
<!-- /.box -->

<!-- box-end -->

@endsection