@extends('app.layout')
@section('content')
@php
$permissionArray = array();
foreach($curRole->permissions as $key=>$permission){
 array_push($permissionArray, $permission->id);
}
@endphp

<section class="content-header" style="padding: 15px 0 10px 0">
	<h1>Dashboard</h1>
	<ol class="breadcrumb">
		<li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
		<li class="active"><a href="/Authentication/Role/List">Role</a></li>
		<li class="active"><a href="/Authentication/Role/List/Add/New">Create Role</a></li>
	</ol>
</section>
@if ( session('massage') )
<section >
	<div class="alert alert-success alert-dismissable remove-button-after-3-sec">
		<a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
		<strong>Success!</strong> {{session('massage')}}
	</div>
</section>
@endif


<div class="box box-primary">
  <div class="box-header">
    <h3 class="box-title">Create Role</h3>
  </div>
  <!-- /.box-header -->
  <form method="POST" action="/Authentication/Role/List/{{$curRole->id}}">
    <div class="box-body">
    {{ csrf_field() }}
    {{ method_field("PATCH") }}

    <div class="row">
      <div class="col-md-6 {{ $errors->has('name') ? ' has-error' : '' }} ">
        <div class="from-group">
          <label for="name" >Name <span title="Required">*</span></label>
			<input type="text" class="form-control"  name="name" id="name"  placeholder="bill-officer" value="{{ $curRole->name }}" required>

          @if ($errors->has('name'))
          <span class="help-block">
            <strong>{{ $errors->first('name') }}</strong>
          </span>
          @endif
        </div>
      </div>
      <div class="col-md-6 {{ $errors->has('display_name') ? ' has-error' : '' }}">
        <div class="from-group">
          <label for="display_name"  >Display Name</label>
			<input type="text" class="form-control"   name="display_name" id="display_name" placeholder="Bill Officer" value="{{ $curRole->display_name }}" >
          @if ($errors->has('display_name'))
          <span class="help-block">
            <strong>{{ $errors->first('display_name') }}</strong>
          </span>
          @endif
        </div>
      </div>
    </div>
    <div class="clearfix">&nbsp;</div>

    <div class="row">
      <div class="col-md-12">
        <div class="form-group">
         <label  for="permission">Permissions</label>
			<select name="permission[]" id="permission" class="form-control select2 " multiple required>
				@foreach($permissions as $key=>$permission)
				<option @if( in_array($permission->id, $permissionArray) ) selected @endif value="{{$permission->id}}">{{$permission->name}}</option>
				@endforeach
			</select>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-md-12">
        <div class="form-group">
         <label  for="description">Description</label>
			<textarea  style="resize:none" name="description" class="form-control" placeholder="User Who Can Create Invoice">{{ $curRole->description }}</textarea>
        </div>
      </div>
    </div>

  </div>
  <!-- /.box-body -->
   <div class="box-footer">
    <button type="submit" class="btn btn-primary">
                Update 
            </button>
    </div>
</form>

</div>
<!-- /.box -->

<!-- box-end -->

@endsection