<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class transactions extends Model
{
    use HasFactory;
    protected $primaryKey = 'transactionID';
    protected $fillable = [
        'type', 'trns_type_id', 'pyee_type', 'payment_type', 'payee_account', 'staff_id', 'payment_method', 'acc_payee', 'reference_no', 'instalment_number', 'bill_no', 'terms_id', 'notes', 'transaction_amount', 'transaction_date', 'bill_date', 'due_date', 'memo_notes', 'file_name', 'created_by', 'updated_by', 'created_at', 'updated_at', 'status', 'isPosted', 'payment_date', 'bank_name', 'deposit_status', 'branch_id', 'company_id'
    ];

    public function PaymentMethod()
    {
        return $this->hasOne(PaymentMethod::class,'id','payment_method');
    }

    public function AccBill()
    {
        return $this->hasOne(AccBill::class,'transaction_id','transactionID');
    }

    public function AccInvoice()
    {
        return $this->hasOne(AccInvoice::class,'transaction_id','transactionID');
    }
    public function AccInvoicePayment()
    {
        return $this->hasMany(AccInvoicePayment::class,'transaction_id','transactionID');
    }


    public function tranType()
    {
        return $this->hasOne(accTransectionTypes::class,'id','trns_type_id');
    }

    public function TransactionProductDetails()
    {
        return $this->hasMany(TransactionProductDetails::class,'trans_id','transactionID');
    }

    public function transactionCr_informations()
    {
        return $this->hasMany(TransactionCr::class,'trans_id','transactionID');
    }
    public function transactionCr()
    {
        return $this->hasMany(TransactionCr::class,'trans_id','transactionID');
    }
    
    public function transactionDr(){
        return $this->hasMany(TransactionDr::class,'trans_id','transactionID');
    }

    public function transactionDr_informations(){
        return $this->hasMany(TransactionDr::class,'trans_id','transactionID');
    }

    public function vendor()
    {
        return $this->hasOne(Vendor::class,'id','payee_account');
    }

    public function customer()
    {
        return $this->hasOne(Customer::class,'id','payee_account');
    }
    
    public function staff()
    {
        return $this->hasOne(employee::class,'id','payee_account');
    }
    public function TransactionLog()
    {
        return $this->hasMany(TransactionLog::class,'transaction_id','transactionID');
    }
    public function TransactionCostCenter()
    {
        return $this->hasMany(TransactionCostCenter::class,'trans_id','transactionID');
    } 
    public function CompanyBranche()
    {
        return $this->hasOne(CompanyBranche::class,'id','branch_id');
    } 
    public function CompanyName()
    {
        return $this->hasOne(CompanyName::class,'id','company_id');
    }    

}

 