<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class employee extends Model
{
    use HasFactory;
     
    protected $fillable = [
        'employment_type', 'designation_id', 'full_name', 'nick_name', 'email', 'mobile', 'employee_id', 'other_id', 'gender', 'marital_status', 'date_of_birth', 'blood_group', 'department', 'nationality', 'nid', 'company_name', 'photo', 'joining_date', 'probation', 'contact_start_date', 'contact_end_date', 'confirmation_date', 'permanent_street', 'permanent_city', 'permanent_state', 'permanent_pcode', 'permanent_country', 'present_street', 'present_city', 'present_state', 'present_pcode', 'present_country', 'created_at', 'created_by', 'updated_at', 'updated_by', 'status','passport_no','confirmation_date','passport_exp_date','salary'   

    ];

    public function empDesignation(){
        return $this->hasOne(employeeDesignation::class,'id','designation_id');
    }
    public function empDepartment(){
        return $this->hasOne(employeeDepartment::class,'id','department');
    }
    public function empContact(){
        return $this->hasMany(EmployeeContact::class,'employee_id','id');
    }

    public function EmpCompanyName(){
        return $this->hasOne(CompanyName::class,'id','company_name');
    }

    
    // for mobile contact group = 1
    public function empContact1(){
        return $this->hasMany(EmployeeContact::class,'employee_id','id')->where('group_id', 1);
    }
    // for email contact group = 2
    public function empContact2(){
        return $this->hasMany(EmployeeContact::class,'employee_id','id')->where('group_id', 2);
    }
    // for other contact group = 3
    public function empContact3(){
        return $this->hasMany(EmployeeContact::class,'employee_id','id')->where('group_id', 3);
    }
    public function EmergencyContact(){
        return $this->hasOne(StaffEmergencyContact::class,'staff_id','id');
    }
    public function EmpJob(){
        return $this->hasOne(EmployeeJob::class,'employee_id','id');
    }
    public function staffJobHistory()
    {
        return $this->hasMany(StaffJobHistory::class,'staff_id','id');
    }
    public function staffEducationHistory()
    {
        return $this->hasMany(StaffEducationHistory::class,'staff_id','id');
    }

    public function EmpTrainingHistory()
    {
        return $this->hasMany(EmployeeTrainingHistory::class,'employee_id','id');
    }
    public function EmpAllocationHistory()
    {
        return $this->hasMany(EmployeeAllocation::class,'employee_id','id');
    }

    public function mycompany(){
        return $this->hasOne(CompanyName::class,'id','company_name');
    }

    // public function DueCount()
    // { 
    //     $dateof = date('Y-m-d 23:59:59');
    //     return employee::selectRaw('count(id) as total')->where('confirmation_date','',$dateof);
    // }

    


}
