<?php

namespace App\Models;
// use Illuminate\Support\Facades\Auth;
// use App\Models\DB;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
// use HasRoles;
class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role_id',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function roles()

    {

        return $this->belongsToMany(Role::class);

    }
    public function UserRole(){
        return $this->hasOne(UserRole::class,'id','role_id');
        // return $this->belongsToMany(UserRole::class);
        // return $this->roles->pluck('name');
    }
    public function UserRoleCheck($value='role-list')
    {
        return $permission_id = DB::table('users')
            ->select('p.id as pid')
            ->join('user_role_and_permissions', 'users.role_id', '=', 'user_role_and_permissions.role_id')
            ->join('user_permissions', 'user_permissions.id', '=', 'user_role_and_permissions.permission_id')
            ->whare('users.id','=',Auth::user()->id)
            ->whare('user_permissions.name','=',$value)
            ->limit(1)
            ->get();
    }
// SELECT p.id
// FROM users u
// LEFT JOIN user_role_and_permissions rp ON rp.role_id=u.role_id
// LEFT JOIN user_permissions p ON p.id = rp.permission_id
// WHERE u.id=3 AND p.name='role-list'

     public function staff()
    {
        return $this->hasOne(Staff::class,'login_id','id');
    }
}
