<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrainingEnroll extends Model
{
    use HasFactory;
    protected $fillable = [
       'schedule_id', 'session_code', 'training_id', 'seat', 'status', 'created_by', 'updated_by', 'created_at', 'updated_at', 'notes'
    ];

	public function TrainingEnrollDetail(){
        return $this->hasMany(TrainingEnrollDetail::class,'schedule_id','schedule_id');
        // return $this->hasMany(TrainingEnrollDetail::class,'enroll_id','id');
    }
    public function training(){
        return $this->hasOne(SetTraining::class,'id','training_id');
    }
    public function training2(){
        return $this->hasOne(SetTraining::class,'id','schedule_id');
    }
    public function TrainingSchedule(){
        return $this->hasOne(TrainingSchedule::class,'id','schedule_id');
    }

   
    public function EnrollCount()
    { 
        return $this->hasMany(TrainingEnrollDetail::class,'schedule_id','schedule_id')
        // ->groupBy('schedule_id')
        ->selectRaw('count(schedule_id) as total')->where('booked',1);
        // ->selectRaw('schedule_id,count(schedule_id) as total')
    }


    public function TrainingEvaluation(){
        return $this->hasMany(TrainingEvaluation::class,'session_id','schedule_id');
    }

}
