<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SurveyConfigTemplate extends Model
{
    use HasFactory;
     // public $timestamps = false;
    protected $fillable = [
        'name', 'name2', 'type_id', 'date', 'created_by', 'updated_by', 'created_at', 'updated_at', 'prepared_name', 'notes', 'status'
    ];

    public function ratingSum()
	{
	  return $this->hasMany('App\Rating')
	    ->selectRaw('COUNT(question_id) as total')
	    ->groupBy('template_id');
	}

	public function templateQuestionCount(){
      return $this->hasOne(SurveyConfigTemplateQuestion::class,'template_id','id')->selectRaw('COUNT(question_id) as total')->groupBy('template_id');
    }
    public function question()
	{
	  return 1;
	}
    
}
