<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SurveyConfigQuestion extends Model
{
    use HasFactory;
    public $timestamps = false;
    protected $fillable = [
        'section_id', 'name', 'name2', 'weight', 'status','answer_type'
    ];
    public function section(){
        return $this->hasOne(ExamSection::class,'id','section_id');
    }
    // public function answerSet1(){
    //   return $this->hasMany(SurveyConfigQuestionSet::class,'question_id','id');
    // }

    public function answerLogSet(){
      return $this->hasMany(SurveySubmitLog::class,'question_id','id');
    }
    // public function question_count(){
    //   return $this->hasMany(SurveySubmitLog::class,'question_id','id');
    // }
    public function question_count(){
        return $this->hasMany(SurveySubmitLog::class,'question_id','id');
    }
    public function question_answers(){
        return $this->hasMany(SurveyConfigQuestionSet::class,'question_id','id');
    }

  //   public function answerSet()
		// {
		// return $this->hasManyThrough('SurveyConfigQuestionSet', 'SurveyConfigAnswer', 'answer_id', 'id');
		// }

	public function answerSet()
    {
        return $this->hasManyThrough(
            SurveyConfigAnswer::class, // 3rd tbl
            SurveyConfigQuestionSet::class, // 2nd tbl
            'question_id', // Foreign key on the 2nd table...
            'id', // Foreign key on the 1st main  table...
            'id', // Local key on the 3rd table...
            'answer_id' // Local key on the 2nd table...
        )->orderBy('weight');
    }

    
    // public function deployments()
    // {
    //     return $this->hasManyThrough(
    //         Deployment::class,
    //         Environment::class,
    //         'project_id', // Foreign key on the environments table...
    //         'environment_id', // Foreign key on the deployments table...
    //         'id', // Local key on the projects table...
    //         'id' // Local key on the environments table...
    //     );
    // }
}

