<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SurveyConfigAnswer extends Model
{
    use HasFactory;
    public $timestamps = false;
    protected $fillable = [
        'section_id', 'name','name2', 'weight', 'status'
    ];
    public function section(){
        return $this->hasOne(ExamSection::class,'id','section_id');
    }

    public function anscount(){
        return $this->hasMany(SurveySubmitLog::class,'answer_id','id');
    }
    public function questionSet(){
        return $this->hasMany(SurveyConfigQuestionSet::class,'answer_id','id');
    }
}
