<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalesOrder extends Model
{
    use HasFactory;
    protected $fillable = [
    	'quotation_no','po_number', 'sales_order_number', 'customer_id', 'expiration_date', 'attention', 'so_date', 'owner_id', 'approver_id', 'vat_total', 'discount_total', 'discount_type', 'net_total', 'terms_notes', 'file_name', 'created_by', 'updated_by', 'created_at', 'updated_at', 'company_id', 'branch_id', 'status'

    ];

    public function customer()
    {
        return $this->hasOne(Customer::class,'id','customer_id');
    }

    public function employee_owner()
    {
        return $this->hasOne(employee::class,'id','owner_id');
    }

    public function employee_approver()
    {
        return $this->hasOne(employee::class,'id','approver_id');
    }

    public function SalesOpportunity()
    {
        return $this->hasOne(SalesOpportunity::class,'id','ref_number');
    }
    public function SalesQuotation()
    {
        return $this->hasOne(SalesQuotation::class,'id','quotation_no');
    }

    public function SalesOrderItem()
    {
        return $this->hasMany(SalesOrderItem::class,'so_id','id');
    }
    public function SalesOppOrderLog()
    {
        return $this->hasMany(SalesOppOrderLog::class,'sales_order_id','id');
    }
}
