<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalesOpportunity extends Model
{
    use HasFactory;
    protected $fillable = [
    	'opportunity_number', 'opportunity_name', 'customer_id', 'type', 'owner', 'close_date', 'probability', 'amount', 'currency', 'primary_source', 'lead_source', 'stage', 'status', 'company_id', 'branch_id'

    ];

    public function customer()
    {
        return $this->hasOne(Customer::class,'id','customer_id');
    }

    public function employee()
    {
        return $this->hasOne(employee::class,'id','owner');
    }
    public function SalesOppOrderLog()
    {
        return $this->hasMany(SalesOppOrderLog::class,'opportunity_id','id');
    }

}


