<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OpdPatientsRegistration extends Model
{
    use HasFactory;
    protected $primaryKey = 'opdID';
    protected $fillable = [
      'reg_date', 'patient_id', 'patient_name', 'doctor_id', 'serial_no', 'opdptype', 'visit_type', 'doctor_reg_fee', 'chief_complaint', 'agent_id', 'created_by', 'updated_by', 'status', 'created_at', 'updated_at'
      ];

    public function Customer()
    {
        return $this->hasOne(Customer::class,'id','patient_id');
    }

    public function Doctor()
    {
        return $this->hasOne(Doctor::class,'dID','doctor_id');
    }

    public function User()
    {
        return $this->hasOne(User::class,'id','created_by');
    }
    public function Agent()
    {
        return $this->hasOne(Agent::class,'agentID','agent_id');
    }

}

