<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HubList extends Model
{
    use HasFactory;
    public $timestamps = false;
    protected $primaryKey = 'hubID';
    protected $fillable = [        
     'hub_name', 'od_name', 'hub_code', 'orgdest_id', 'country', 'status'
    ];

    public function OrigDest()
    {
      return $this->hasOne(OrigDest::class,'odID','orgdest_id');
    }

    public function countries()
    {
      return $this->hasOne(countries::class,'id','country');
    }

}
