<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HrLeavePolicy extends Model
{
    use HasFactory;
    protected $fillable = [
    'id', 'name', 'leave_type_id', 'policy_type_id', 'value', 'company_id'     
    ];   

    public function company_name(){
        return $this->hasOne(CompanyName::class,'id','company_id');
    }

    public function Leave_Type_name(){
        return $this->hasOne(HrLeaveType::class,'id','leave_type_id');
    }

    public function Policy_Type(){
        return $this->hasOne(SetConfig::class,'id','policy_type_id');
    }
}
