<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeConfirmation extends Model
{
    use HasFactory;
    protected $fillable = [
        'employee_id', 'company_id', 'dept_id', 'designation_id', 'due_date', 'confirmation_date', 'current_salary', 'recommended_salary', 'approved_salary', 'recommender_id', 'recommend_is', 'recommend_comment', 'recommend_datetime', 'approver_id', 'approve_is', 'approve_comment', 'approve_datetime', 'total_exam_marks', 'achieve_marks', 'created_by', 'updated_by', 'created_at', 'updated_at', 'status'
    ];

    public function empDesignation(){
        return $this->hasOne(employeeDesignation::class,'id','designation_id');
    }
    public function empDepartment(){
        return $this->hasOne(employeeDepartment::class,'id','dept_id');
    }

    public function empInfo(){
        return $this->hasOne(employee::class,'id','employee_id');
    }

    public function EmpCompanyName(){
        return $this->hasOne(CompanyName::class,'id','company_id');
    }

    public function recommend_user_name(){
        return $this->hasOne(User::class,'id','recommender_id');
    }
}

