<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Doctor extends Model
{
    use HasFactory;
    protected $primaryKey = 'dID';
    protected $fillable = [
      'discount_type', 'specialisty', 'depertment', 'dtype', 'regNo', 'room_no', 'dName', 'displayName', 'photo', 'nid', 'dob', 'mobile', 'phone', 'email', 'commision', 'street1', 'street2', 'ps', 'dist', 'division', 'postCode', 'time_slot', 'hospital_name', 'notes', 'status', 'created_by', 'updated_by', 'created_at', 'updated_at','fee'
    ];

    public function AddressArea()
    {
        return $this->hasOne(AddressArea::class,'id','area_id');
    }
    public function MedicalDepertment()
    {
        return $this->hasOne(MedicalDepertment::class,'id','depertment');
    }

}
