<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DiagonosticInvoice extends Model
{
    use HasFactory;
    protected $fillable = [
       'patient_id', 'doctor_id', 'agent_id', 'payment_method', 'acc_id', 'sub_total', 'discount_total', 'bill_total', 'paid_total', 'disc_type', 'status', 'order_date', 'created_at', 'updated_at', 'created_by', 'updated_by'
    ];

   public function Customer()
    {
        return $this->hasOne(Customer::class,'id','patient_id');
    }

    public function Doctor()
    {
        return $this->hasOne(Doctor::class,'dID','doctor_id');
    }

    public function User()
    {
        return $this->hasOne(User::class,'id','created_by');
    }
    public function Agent()
    {
        return $this->hasOne(Agent::class,'agentID','agent_id');
    }
}


