<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Agent extends Model
{
    use HasFactory;
    protected $primaryKey = 'agentID';
    protected $fillable = [
      'code', 'kam_id', 'agent_type', 'organization_name', 'name', 'email', 'phone', 'mobile', 'address', 'website', 'commission', 'photo', 'status', 'created_at', 'updated_at', 'created_by', 'updated_by', 'target', 'notes', 'area_id'
    ];

    public function AddressArea()
    {
        return $this->hasOne(AddressArea::class,'id','area_id');
    }
}
