<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccInvoice extends Model
{
    use HasFactory;
    protected $fillable = [
    'transaction_id', 'type', 'party_id', 'party_type', 'reference_no','po_number', 'bill_no', 'bill_date', 'terms', 'due_date', 'amount_total','discount_type', 'discount_total', 'vat_total', 'net_total', 'paid_total', 'memo_notes', 'file_name', 'company_id', 'branch_id','agent_id','doctor_id','payment_method','acc_id'
    ];

    public function Customer()
    {
        return $this->hasOne(Customer::class,'id','party_id');
    }

    public function Doctor()
    {
        return $this->hasOne(Doctor::class,'dID','doctor_id');
    }

    public function User()
    {
        return $this->hasOne(User::class,'id','created_by');
    }
    public function Agent()
    {
        return $this->hasOne(Agent::class,'agentID','agent_id');
    }

    public function AccInvoicePayment()
    {
    return $this->hasOne(AccInvoicePayment::class,'bill_id','id')->orderby('id');
    }
}
