<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccChartOfAccountName extends Model
{
    use HasFactory;
    protected $primaryKey = 'account_Name_id';
    protected $fillable = [
        'account_number', 'account_name', 'sense','account_opening_balance', 'as_of_opening_balance', 'account_description', 'detail_type_id', 'chq', 'account_type_id', 'app_company_id', 'app_branch_id'
    ];

    public function account_details_informations()
    {
        return $this->hasOne(AccChartOfAccountDetailsTypes::class,'detail_type_id','detail_type_id');
    }

    public function account_type_informations()
    {
        return $this->hasOne(AccChartOfAccountTypes::class,'account_type_ID','account_type_id');
    }
    
    
    public function DrTotalByAccID()
	{ 
    	return $this->hasOne(TransactionDr::class,'account_id','account_Name_id')
    	->selectRaw('sum(amount) as total')
    	->groupBy('account_id');
	}
    public function CrTotalByAccID()
	{ 
    	return $this->hasOne(TransactionCr::class,'account_id','account_Name_id')
    	->selectRaw('sum(amount) as total')
    	->groupBy('account_id');
	}

}
