<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;
use Validator;

use App\Models\TrainingSchedule;
use Illuminate\Http\Request;

class TrainingScheduleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // $datas =  TrainingSchedule::oldest('training_id')->paginate(50);

        $trainer_name = $request->trainer_name;
        $training_id = $request->training_id;
        $perPage = $request->has('perPage')?$request->perPage:10;

        $datas = TrainingSchedule::where('status',1)
        ->when($trainer_name, function($q) use($trainer_name){
          return $q->where('trainer_name',$trainer_name);
        })
        ->when($training_id, function($q) use($training_id){
          return $q->where('training_id',$training_id);
        })
        ->paginate($perPage);

        return view('settings.TrainingScheduleList',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('settings.TrainingScheduleCreate');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
      'training_id' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new TrainingSchedule;
      $data->fill($request->all());
      $data->created_by = $request->user()->id;
      $data->updated_by = $request->user()->id;
      if ($data->save()) {        
        return back()->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TrainingSchedule  $trainingSchedule
     * @return \Illuminate\Http\Response
     */
    public function show(TrainingSchedule $trainingSchedule)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\TrainingSchedule  $trainingSchedule
     * @return \Illuminate\Http\Response
     */
    public function edit(TrainingSchedule $trainingSchedule, $id)
    {
        $data =   TrainingSchedule::findOrFail($id);
      return view('settings.TrainingScheduleEdit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TrainingSchedule  $trainingSchedule
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, TrainingSchedule $trainingSchedule)
    {
        $id = $request->id;
      $data =  TrainingSchedule::findOrFail($id);
      $data->fill($request->all());
      
      $data->updated_by = $request->user()->id;
      $saved = $data->save();
      if (isset($request->url)) {
        return redirect($request->url)->with('massage','Information updated Succesfully');
      }
      return back()->with('massage','Information updated Succesfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TrainingSchedule  $trainingSchedule
     * @return \Illuminate\Http\Response
     */
    public function destroy(TrainingSchedule $trainingSchedule)
    {
        //
    }
}
