<?php

namespace App\Http\Controllers\Settings;

use App\Http\Controllers\Controller;
use App\Models\SetTraining;
use Illuminate\Http\Request;
use Validator;

class SetTrainingController extends Controller
{
     /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
      
        $category_id = $request->category_id;
        $name = $request->name;
        $perPage = $request->has('perPage')?$request->perPage:10;

        $datas = SetTraining::where('status',1)
        ->when($name, function($q) use($name){
          return $q->where('name',$name);
        })
        ->when($category_id, function($q) use($category_id){
          return $q->where('category_id',$category_id);
        })
        ->paginate($perPage);
        return view('settings.SetTrainingList',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('settings.SetTrainingCreate');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      $validator = Validator::make($request->all(), [
      'name' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new SetTraining;
      $data->fill($request->all());
      $data->created_by = $request->user()->id;
      $data->updated_by = $request->user()->id;
      if ($data->save()) {        
        return back()->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\SetTraining  $setTraining
     * @return \Illuminate\Http\Response
     */
    public function show(SetTraining $setTraining)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\SetTraining  $setTraining
     * @return \Illuminate\Http\Response
     */
    public function edit(SetTraining $setTraining, $id)
    {
        $data =   SetTraining::findOrFail($id);
      return view('settings.SetTrainingEdit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\SetTraining  $setTraining
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, SetTraining $setTraining)
    {
      $id = $request->id;
      $data =  SetTraining::findOrFail($id);
      $data->fill($request->all());
      
      $data->updated_by = $request->user()->id;
      $saved = $data->save();
      if (isset($request->url)) {
        return redirect($request->url)->with('massage','Information updated Succesfully');
      }
      return back()->with('massage','Information updated Succesfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\SetTraining  $setTraining
     * @return \Illuminate\Http\Response
     */
    public function destroy(SetTraining $setTraining)
    {
        //
    }
}
