<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;
use App\Models\SetConfig;
use Illuminate\Http\Request;
use Validator;

class SetConfigController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request, $rtn_data=0)
    {

      $perPage = $request->has('plimit')?$request->input('plimit'):50;
      $key_name = $request->key_name;
      $value = $request->value;
      $status = $request->status;

      $datas = SetConfig::oldest('key_name')
      ->when($key_name, function($q) use($key_name){
        return $q->where('key_name','like',"%{$key_name}%");
      })
      ->when($value, function($q) use($value){
        return $q->where('value','like',"%{$value}%");
      })
      ->when($status, function($q) use($status){
        return $q->where('status',$status);
      })
      ->when(isset($status) && ($status==0), function($q) use($status){
        return $q->where('status',$status);
      })
      ->paginate($perPage);

      if($rtn_data>0) return $datas;
      return view('settings.SetKeyConfigList',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('settings.SetKeyConfigCreate');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
      'key_name' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new SetConfig;
      $data->fill($request->all());
      if ($data->save()) {        
        return back()->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\SetConfig  $setConfig
     * @return \Illuminate\Http\Response
     */
    public function show(SetConfig $setConfig)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\SetConfig  $setConfig
     * @return \Illuminate\Http\Response
     */
    public function edit(SetConfig $setConfig, $id)
    {
        $data =   SetConfig::findOrFail($id);
      return view('settings.SetKeyConfigEdit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\SetConfig  $setConfig
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, SetConfig $setConfig)
    {
        $id = $request->id;
      $data =  SetConfig::findOrFail($id);
      $data->fill($request->all());
      
      // $data->updated_by = $request->user()->id;
      $saved = $data->save();
      if (isset($request->url)) {
        return redirect($request->url)->with('massage','Information updated Succesfully');
      }
      return back()->with('massage','Information updated Succesfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\SetConfig  $setConfig
     * @return \Illuminate\Http\Response
     */
    public function destroy(SetConfig $setConfig)
    {
        //
    }
}
