<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;
use App\Models\SetBankName;
use Illuminate\Http\Request;
use Validator;

class SetBankNameController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // $datas =  SetBankName::oldest('name')->paginate(50);

        $bank_name = $request->bank_name;
        $sort_name = $request->sort_name; 
        $account_number = $request->account_number;
        $company_id = $request->company_id;
        $perPage = $request->has('perPage')?$request->perPage:10;

        

        $datas = SetBankName::where('status',1)
        ->when($bank_name, function($q) use($bank_name){
          return $q->where('name',$bank_name);
        })
        ->when($sort_name, function($q) use($sort_name){
          return $q->where('sort_name',$sort_name);
        })
        ->when($account_number, function($q) use($account_number){
          return $q->where('account_number',$account_number);
        })
        ->when($company_id, function($q) use($company_id){
          return $q->where('company_id',$company_id);
        })
        ->paginate($perPage);

        return view('settings.SetBankNameList',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('settings.SetBankNameCreate');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      $validator = Validator::make($request->all(), [
      'name' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new SetBankName;
      $data->fill($request->all());
      $data->created_by = $request->user()->id;
      $data->updated_by = $request->user()->id;
      if ($data->save()) {        
        return back()->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\SetBankName  $setBankName
     * @return \Illuminate\Http\Response
     */
    public function show(SetBankName $setBankName)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\SetBankName  $setBankName
     * @return \Illuminate\Http\Response
     */
    public function edit(SetBankName $setBankName, $id)
    {
        $data =   SetBankName::findOrFail($id);
      return view('settings.SetBankNameEdit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\SetBankName  $setBankName
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, SetBankName $setBankName)
    {
        $id = $request->id;
      $data =  SetBankName::findOrFail($id);
      $data->fill($request->all());
      
      $data->updated_by = $request->user()->id;
      $saved = $data->save();
      if (isset($request->url)) {
        return redirect($request->url)->with('massage','Information updated Succesfully');
      }
      return back()->with('massage','Information updated Succesfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\SetBankName  $setBankName
     * @return \Illuminate\Http\Response
     */
    public function destroy(SetBankName $setBankName)
    {
        //
    }
}
