<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;
use App\Models\AddressCity;
use App\Models\AddressZone;
use App\Models\AddressArea;


use Illuminate\Http\Request;
use Validator;

class AddressCityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $cityName = $request->cityName;
        $perPage = $request->has('perPage')?$request->perPage:10;

        $data_city = AddressCity::when($cityName, function($q) use($cityName){
          return $q->where('name',$cityName);
        })
        ->paginate($perPage);


        $city_id = $request->city_id;
        $zoneName = $request->zoneName;
        $perPage1 = $request->has('perPage1')?$request->perPage1:10;

        $data_zone = AddressZone::where('status',1)
        ->when($zoneName, function($q) use($zoneName){
          return $q->where('name',$zoneName);
        })
        ->when($city_id, function($q) use($city_id){
          return $q->where('city_id',$city_id);
        })
        ->paginate($perPage1);



        $data_area = AddressArea::where('status',1)
        ->get();

        return view('settings.CityZoneArea',compact('data_city','data_zone','data_area'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
      'name' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new AddressCity;
      $data->fill($request->all());
      
      if ($data->save()) {        
        return back()->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AddressCity  $addressCity
     * @return \Illuminate\Http\Response
     */
    public function show(AddressCity $addressCity)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AddressCity  $addressCity
     * @return \Illuminate\Http\Response
     */
    public function edit(AddressCity $addressCity)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AddressCity  $addressCity
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, AddressCity $addressCity)
    {
      $id = $request->id;
      $data =  AddressCity::findOrFail($id);
      $data->fill($request->all());
      
      
      $saved = $data->save();
      
      if ($saved) {        
        return back()->with('massage','Information Updated Successfully');
      }else return back()->with('error','Information not updated....')->withInput();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AddressCity  $addressCity
     * @return \Illuminate\Http\Response
     */
    public function destroy(AddressCity $addressCity)
    {
        //
    }
}
