<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;

use App\Models\AccChartOfAccountName;
use App\Models\AccChartOfAccountDetailsTypes;
use App\Models\AccChartOfAccountTypes;
use Illuminate\Http\Request;

use Validator;

class AccChartOfAccountNameController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data_AccountName = AccChartOfAccountName::orderBy('account_type_id')->get();

        $data_AccountDetails = AccChartOfAccountDetailsTypes::orderBy('group_id')->get();

        $data_AccountTypes = AccChartOfAccountTypes::orderBy('root_id')->get();

        return view('settings.ChartOfAccounts',compact('data_AccountName','data_AccountDetails','data_AccountTypes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      $validator = Validator::make($request->all(), [
      'account_name' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new AccChartOfAccountName;
      $data->fill($request->all());

      $data2 =  AccChartOfAccountDetailsTypes::findOrFail($request->detail_type_id);

      $data->account_number = $data2->dcode.$request->account_number;

      $data->updated_by = $request->user()->id;
      $data->created_by = $request->user()->id;
      
      if ($data->save()) {        
        return redirect($request->url.'?tab='.$request->tab)->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AccChartOfAccountName  $accChartOfAccountName
     * @return \Illuminate\Http\Response
     */
    public function show(AccChartOfAccountName $accChartOfAccountName)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AccChartOfAccountName  $accChartOfAccountName
     * @return \Illuminate\Http\Response
     */
    public function edit(AccChartOfAccountName $accChartOfAccountName)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AccChartOfAccountName  $accChartOfAccountName
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, AccChartOfAccountName $accChartOfAccountName)
    {
      $id = $request->id;
      $data =  AccChartOfAccountName::findOrFail($id);
      $data->fill($request->all());
      
      $data2 =  AccChartOfAccountDetailsTypes::findOrFail($request->detail_type_id);

      $data->account_number = $data2->dcode.$request->account_number;
      
      $saved = $data->save();
      
      if ($saved) {        
        return redirect($request->url.'?tab='.$request->tab)->with('massage','Information Updated Successfully');
      }else return back()->with('error','Information not updated....')->withInput();

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AccChartOfAccountName  $accChartOfAccountName
     * @return \Illuminate\Http\Response
     */
    public function destroy(AccChartOfAccountName $accChartOfAccountName)
    {
        //
    }
}
