<?php

namespace App\Http\Controllers\Configuration\Settings;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class UsersListController extends Controller
{
     use ResetsPasswords;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       $datas =  User::oldest('name')
        ->paginate(15);
        return view('Authentication.Users.UsersLists',compact('datas'));
    }

   
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($user, Request $request)
    {
        $user =  User::with('roles')->findOrFail($user);
        if ($user->user_type == 1 && $request->user()->user_type != 1 ) {
            return back()->with('massage','This is a Admin User. U can not modify this one.');
        }
        // dd( count($user->roles) );
        return view('Authentication.Users.EditUser',compact('user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        $user = User::findOrFail($id);
        $user->fill($request->all());
        $user->save();

        // if ( $request->has('role_id') ) {
        //     $user->roles()->sync([$request->role_id]);
        // }

        if ($request->has('password')) {
            if (!empty($request->password)) {
                Validator::make($request->all(), [
                    'name' => 'required|string|max:191',
                    'password' => 'required|string|min:6|confirmed',
                ])->validate();
                // $this->resetPassword( $user,$request->password);
                $user->forceFill([
                    'password' => bcrypt($request->password),
                    'remember_token' => Str::random(60),
                ])->save();
            }
        }

        return redirect('/Authentication/Users/List')->with('massage','Succesfully Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {
        //
    }
}
