<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\employee;
use App\Models\employeeDepartment;
use App\Models\employeeDesignation; 
use App\Models\countries; 
use App\Models\CompanyName;
use App\Models\CompanyType;
use App\Models\CompanyBranche;
use App\Models\ExamSection;
use App\Models\SurveyConfigAnswer;
use App\Models\SurveyConfigQuestion;
use App\Models\SurveyConfigTemplate;
use App\Models\TrainingCompetency;
use App\Models\SetConfig;
use App\Models\SetTraining;
use App\Models\Staff;
use App\Models\SetTrainingCategory;
use App\Models\TrainingSchedule;
use App\Models\BankNameList;
use App\Models\AddressCity;
use App\Models\AddressZone;
use App\Models\AddressArea;
use App\Models\AccChartOfAccountDetailsTypes;
use App\Models\CustomerContact;
use App\Models\AccBill;
use App\Models\AccInvoice;
use App\Models\TransactionDr;
use App\Models\RequisitionItem;
use DB;

class AjaxController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // return 'test';
         return view('Sales.search');
            $msg = "This is a simple message.";
      return response()->json(array('msg'=> $msg), 200);
    }
    public function index2()
    {
        // return 'test';
         return view('Sales.search2');
    }

    public function autocomplete(Request $request)
    {
        // return $request['query'];
        $data = CompanyName::select('id','name')
                ->where('name','LIKE','%'.$request['query'].'%')
                ->get();
   
        return response()->json($data);
    }

    public function autocomplete2(Request $request){

      $search = $request->search;

      $data = DB::table('employees')
        ->where('full_name', 'like', '%' .$search . '%')
        ->orWhere('mobile', 'like', '%' .$search . '%')  
        ->limit(20)->get();


      $response = array(); 
      foreach($data as $val){
        // return json_encode($val);
        $response[] = array(
          "value"=>$val->id,
          "label"=>$val->full_name,
          "mobile"=>$val->mobile,
          "name"=>$val->full_name,
          "name"=>$val->full_name,
          "id"=>$val->id,
        );        
      }
      return response()->json($response);
   }

  public function searchCustomer(Request $request){
    $search = $request->search;
    $data = DB::table('customers')
    ->where('status', 1)
    ->where('name', 'like', '%' .$search . '%')
    ->orWhere('mobile', 'like', '%' .$search . '%')  
    ->limit(20)->get();

    $response = array(); 
      foreach($data as $val){
        // return json_encode($val);
        $addLable = '';
        if($val->age>0){ 
          $addLable .= ''.$val->age;
          if($val->age_type==1) $addLable .= ' Y, ';
          elseif($val->age_type==2) $addLable .= ' M, ';
          elseif($val->age_type==3) $addLable .= ' D, ';
        }

        $response[] = array(
          "value"=>$val->id,
          "name"=>$val->name,
          "label"=>$val->name .' ['.$addLable.' '.$val->gender.']',
          "mobile"=>$val->mobile,
          "id"=>$val->id,
          "age"=>$val->age,
          "age_type"=>$val->age_type,
          "gender"=>$val->gender,
          "blood_group"=>$val->blood_group,
        );        
      }
      return response()->json($response);
  }

  public function searchDoctor(Request $request){
    $search = $request->search;
    // if(empty($search)) return 0;
    $data = DB::table('doctors')
    ->where('status', 1)
    ->where('dName', 'like', '%' .$search . '%')
    // ->orWhere('dID', 'like', '%' .$search . '%')  
    ->orWhere('dID',$search )  
    ->limit(20)->get();

    $response = array(); 
      foreach($data as $val){
        // return json_encode($val);
        $response[] = array(
          "value"=>$val->dID,
          "label"=>$val->dName,
          "mobile"=>$val->mobile,
          "name"=>$val->dName,
          "room_no"=>$val->room_no,
          "fee"=>$val->fee,
          "displayName"=>'', //$val->displayName,
          "specialisty"=>$val->specialisty,
          "id"=>$val->dID,
        );        
      }
      return response()->json($response);
  }

  public function searchPatient(Request $request){
    $search = $request->search;
    $data = DB::table('customers')
    ->where('status', 1)
    ->where('dName', 'like', '%' .$search . '%')
    ->orWhere('mobile', 'like', '%' .$search . '%')  
    ->limit(20)->get();

    $response = array(); 
      foreach($data as $val){
        // return json_encode($val);
        $response[] = array(
          "value"=>$val->dID,
          "label"=>$val->dName,
          "mobile"=>$val->mobile,
          "name"=>$val->dName,
          "room_no"=>$val->room_no,
          "displayName"=>$val->displayName,
          "specialisty"=>$val->specialisty,
          "id"=>$val->dID,
        );        
      }
      return response()->json($response);
  }

  public function searchProduct(Request $request){
    $search = $request->search;
    if(empty($search)) return 0;
    $data = DB::table('products')
    ->where('product_name', 'like', '%' .$search . '%')
    // ->orWhere('product_code', 'like', '%' .$search . '%')  
    // ->orWhere('barcode',$search)  
    ->where('sale_purchase_both',1)  
    ->orWhere('sale_purchase_both',3)  
    ->limit(20)->get();

    $response = array(); 
      foreach($data as $val){
        // return json_encode($val);
        $response[] = array(
          "value"=>$val->id,
          "label"=>$val->product_name,
          "product_code"=>$val->product_code,
          "barcode"=>$val->barcode,
          "name"=>$val->product_name,
          "price"=>$val->sales_price,
          "id"=>$val->id,
        );        
      }
      return response()->json($response);
   }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function company()
    {
        $data = CompanyName::select('id','name')->get();

        $optiontext = '';
        $value = '';
        foreach ($data as $key => $val) {
            $selected = ($value === $key)?'selected=selected':'';
            $optiontext .= '<option '.$selected.' value="'.$val->id.'"> '.$val->name.' </option>';
        }
        // $optiontext .= '</select>';
        // return $optiontext;
        return response()->json(array('info'=> $optiontext), 200);
    }

    public function city1(Request $request)
    {
      return view('settings.cityzonearea_test');
    }

    public function AddZone(Request $request)
    {
        $cid =  $request->cid;
        $data = AddressZone::when($cid, function ($query) use ($cid) {
            return $query->where('city_id',$cid);
        })->pluck('name','id');
        return json_encode($data);
    }


    public function AddArea(Request $request)
    {
        $cid =  $request->cid;
        $data = AddressArea::when($cid, function ($query) use ($cid) {
            return $query->where('zone_id',$cid);
        })->pluck('name','id');
        return json_encode($data);
    }

    public function empDepartment(Request $request)
    {
        $company_id =  $request->company_id;
        $data = employeeDepartment::when($company_id, function ($query) use ($company_id) {
            return $query->where('company_id',$company_id);
        })->pluck('department','id');
        return json_encode($data);
    }
    public function empDesignation(Request $request)
    {
        $wherid =  $request->company_id;
        $data = employeeDesignation::when($wherid, function ($query) use ($wherid) {
            return $query->where('company_id',$wherid);
        })->pluck('designation','id');
        return json_encode($data);
    }
    

    public function providerName(Request $request)
    {
        $type =  $request->type;
        $data = BankNameList::when($type, function ($query) use ($type) {
            return $query->where('type',$type);
        })->pluck('bankName','id');
        return json_encode($data);
    }


        public function CompanyBranchName(Request $request)
    {
        $type =  $request->type;
        $data = CompanyBranche::when($type, function ($query) use ($type) {
            return $query->where('company_id',$type);
        })->pluck('branch_name','id');

        return json_encode($data);
    }

    public function CustomerContactName(Request $request)
    {
        $type =  intval($request->type);
        $data = CustomerContact::when($type, function ($query) use ($type) {
            return $query->where('customer_id',$type);
        })->pluck('contact_name','id');

        return json_encode($data);
    }


    public function ChartOfAccounts(Request $request)
    {
        $type =  $request->type;

        $data = AccChartOfAccountDetailsTypes::when($type, function ($query) use ($type) {
            return $query->where('group_id',$type);
        })->select('detail_type_name','detail_type_id','dcode')->get();

        $data2 = [];
        foreach($data as $key=>$val){
            $data2[$val->detail_type_id] = $val->dcode.' - '.$val->detail_type_name;
        }
        return json_encode($data2);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }


    // transection

    // bill
    public function dueBill(Request $request, AccBill $accBill,$payee)
    {
      // $pyee_type = substr($payee, strpos($payee, "_") + 1);   
      $payee_account = intval($payee);
      if ($payee_account>0)
      {
        $data = AccBill::where('party_id',$payee_account)->where('amount_total','>','paid_total')->get();
          return \Response::json( $data );
        }else return 'not data found';
    }
    
     // invoice
    public function dueInvoice(Request $request, AccInvoice $accInvoice,$payee)
    {
      // $pyee_type = substr($payee, strpos($payee, "_") + 1);   
      $payee_account = intval($payee);
      if ($payee_account>0)
      {
        $data = AccInvoice::where('party_id',$payee_account)->where('amount_total','>','paid_total')->get();
          return \Response::json( $data );
        }else return 'not data found';
    }

         // DepositPendingTransection
    public function DepositPendingTransection(Request $request, TransactionDr $transactionDr, $payMethodId, $undepoistId, $undepoistDueDate)
    {
      $PayMethodID = intval($payMethodId);
      $UndepoistId = intval($undepoistId);
      $UndepoistDueDate = $undepoistDueDate;

      if ($UndepoistId>0 && $PayMethodID>0)
      {
      $data = TransactionDr::select('transactions.*','acc_transection_types.type_name','customers.name')
      ->leftJoin('transactions', 'transactions.transactionID', '=', 'transaction_drs.trans_id')
      ->leftJoin('acc_transection_types', 'acc_transection_types.id', '=', 'transactions.trns_type_id')
      ->leftJoin('customers', 'customers.id', '=', 'transactions.payee_account')
      ->where('transactions.bank_deposit_ref','==',0)
      ->where('transactions.payment_method',$PayMethodID)
      ->where('transaction_drs.account_id',$UndepoistId)
      ->where('transactions.due_date','<=',$UndepoistDueDate)->get();
          return \Response::json( $data );
        }else return 'not data found';
    }

    public function findPO(Request $request, RequisitionItem $requisitionItem, $reqID)
    {
      // return $reqID;
      if ($reqID>0)
      {
        return $data = RequisitionItem::select('requisition_items.*','products.product_name')
      ->leftJoin('products', 'products.id', '=','requisition_items.product_id')
      ->where('requisition_items.req_id',$reqID)
      ->where('requisition_items.po_id',0)
      ->get();
          return \Response::json( $data );
        }else return 'not data found';

    }
    

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\cr  $cr
     * @return \Illuminate\Http\Response
     */
    public function show(cr $cr)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\cr  $cr
     * @return \Illuminate\Http\Response
     */
    public function edit(cr $cr)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\cr  $cr
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, cr $cr)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\cr  $cr
     * @return \Illuminate\Http\Response
     */
    public function destroy(cr $cr)
    {
        //
    }
}
